/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.scribble.codegen.java.util.ConstructorBuilder;
import org.scribble.codegen.java.util.MethodBuilder;
import org.scribble.codegen.java.util.TypeBuilder;

public class ClassBuilder
extends TypeBuilder {
    protected String superclass;
    protected final List<MethodBuilder> ctors = new LinkedList<MethodBuilder>();

    public ClassBuilder() {
    }

    public ClassBuilder(String name) {
        super(name);
    }

    public void setSuperClass(String superc) {
        this.setterCheck(this.superclass);
        this.superclass = superc;
    }

    public ConstructorBuilder newConstructor(String ... pars) {
        ConstructorBuilder mb = new ConstructorBuilder(this.name);
        mb.addParameters(pars);
        this.ctors.add(mb);
        return mb;
    }

    public MethodBuilder newMethod() {
        MethodBuilder mb = new MethodBuilder();
        this.methods.add(mb);
        return mb;
    }

    public final MethodBuilder newMethod(String name) {
        MethodBuilder mb = this.newMethod();
        mb.setName(name);
        return mb;
    }

    public final boolean hasMethodSignature(String ret, String ... params) {
        for (MethodBuilder mb : this.methods) {
            if (!mb.getReturn().equals(ret) || !ClassBuilder.equalParamSigs(Arrays.asList(params), mb.getParameters())) continue;
            return true;
        }
        return false;
    }

    private static boolean equalParamSigs(List<String> mb1, List<String> mb2) {
        if (mb1.size() == 0) {
            if (mb2.size() != 0) {
                return false;
            }
        } else {
            Iterator<String> params2 = mb2.iterator();
            for (String param1 : mb1) {
                if (!params2.hasNext()) {
                    return false;
                }
                String param2 = params2.next();
                param2 = param2.contains("<") ? param2.substring(0, param2.indexOf("<")) : param2.substring(0, param2.indexOf(" "));
                if ((param1 = param1.contains("<") ? param1.substring(0, param1.indexOf("<")) : param1.substring(0, param1.indexOf(" "))).equals(param2)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected String buildSignature(String clazz) {
        if (!this.mods.isEmpty()) {
            clazz = clazz + this.mods.stream().collect(Collectors.joining(" "));
            clazz = clazz + " ";
        }
        clazz = clazz + "class " + this.name;
        if (!this.params.isEmpty()) {
            clazz = clazz + "<" + this.params.stream().collect(Collectors.joining(", ")) + ">";
        }
        if (this.superclass != null) {
            clazz = clazz + " extends " + this.superclass;
        }
        if (!this.ifaces.isEmpty()) {
            clazz = clazz + " implements ";
            clazz = clazz + this.ifaces.stream().collect(Collectors.joining(", "));
        }
        return clazz;
    }

    @Override
    public String buildBody(String clazz) {
        clazz = clazz + " {";
        clazz = this.buildFields(clazz);
        clazz = this.buildConstructors(clazz);
        clazz = this.buildMethods(clazz);
        clazz = this.buildMemberTypes(clazz);
        clazz = clazz + "\n}";
        return clazz;
    }

    protected String buildConstructors(String clazz) {
        if (!this.ctors.isEmpty()) {
            clazz = clazz + "\n\n";
            clazz = clazz + this.ctors.stream().map(mb -> mb.build()).collect(Collectors.joining("\n\n"));
        }
        return clazz;
    }
}

