/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.del.global;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.MessageTransfer;
import org.scribble.ast.ProtocolDecl;
import org.scribble.ast.ScribNode;
import org.scribble.ast.context.ModuleContext;
import org.scribble.ast.global.GDelegationElem;
import org.scribble.ast.name.qualified.GProtocolNameNode;
import org.scribble.del.ScribDelBase;
import org.scribble.del.global.GProtocolDeclDel;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.Global;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.ProtocolName;
import org.scribble.sesstype.name.Role;
import org.scribble.visit.context.ProtocolDeclContextBuilder;
import org.scribble.visit.wf.DelegationProtocolRefChecker;
import org.scribble.visit.wf.NameDisambiguator;

public class GDelegationElemDel
extends ScribDelBase {
    @Override
    public void enterDisambiguation(ScribNode parent, ScribNode child, NameDisambiguator disamb) throws ScribbleException {
        ModuleContext mc = disamb.getModuleContext();
        GDelegationElem de = (GDelegationElem)child;
        GProtocolName gpn = de.proto.toName();
        if (!mc.isVisibleProtocolDeclName(gpn)) {
            throw new ScribbleException(de.proto.getSource(), "Protocol decl not visible: " + gpn);
        }
    }

    public GDelegationElem visitForNameDisambiguation(NameDisambiguator disamb, GDelegationElem de) throws ScribbleException {
        ModuleContext mc = disamb.getModuleContext();
        GProtocolName fullname = (GProtocolName)mc.getVisibleProtocolDeclFullName(de.proto.toName());
        Role rn = de.role.toName();
        ProtocolDecl<Global> gpd = disamb.job.getContext().getModule(fullname.getPrefix()).getProtocolDecl(fullname.getSimpleName());
        if (!gpd.header.roledecls.getRoles().contains(rn)) {
            throw new ScribbleException(de.role.getSource(), "Invalid delegation role: " + de);
        }
        GProtocolNameNode pnn = (GProtocolNameNode)AstFactoryImpl.FACTORY.QualifiedNameNode(de.proto.getSource(), fullname.getKind(), fullname.getElements());
        return de.reconstruct(pnn, de.role);
    }

    public void leaveMessageTransferInProtocolDeclContextBuilding(MessageTransfer<?> mt, GDelegationElem de, ProtocolDeclContextBuilder builder) throws ScribbleException {
        GProtocolName gpn = de.proto.toName();
        builder.addGlobalProtocolDependency(mt.src.toName(), gpn, de.role.toName());
        mt.getDestinationRoles().forEach(r -> builder.addGlobalProtocolDependency((Role)r, gpn, de.role.toName()));
    }

    @Override
    public void enterDelegationProtocolRefCheck(ScribNode parent, ScribNode child, DelegationProtocolRefChecker checker) throws ScribbleException {
        GProtocolName rootfullname;
        GDelegationElem de = (GDelegationElem)child;
        ModuleContext mc = checker.getModuleContext();
        GProtocolName targetfullname = (GProtocolName)mc.getVisibleProtocolDeclFullName(de.proto.toName());
        if (targetfullname.equals(rootfullname = (GProtocolName)mc.getVisibleProtocolDeclFullName(checker.getProtocolDeclOnEntry().header.getDeclName()))) {
            throw new ScribbleException(de.getSource(), "Recursive protocol dependencies not supported for delegation types: " + de);
        }
        LinkedHashSet todo = new LinkedHashSet();
        ProtocolDecl<Global> targetgpd = checker.job.getContext().getModule(targetfullname.getPrefix()).getProtocolDecl(targetfullname.getSimpleName());
        Set init = ((GProtocolDeclDel)targetgpd.del()).getProtocolDeclContext().getDependencyMap().getDependencies().values().stream().flatMap(v -> v.keySet().stream()).collect(Collectors.toSet());
        todo.addAll(init);
        HashSet<GProtocolName> seen = new HashSet<GProtocolName>();
        while (!todo.isEmpty()) {
            Iterator it = todo.iterator();
            GProtocolName next = (GProtocolName)it.next();
            it.remove();
            seen.add(next);
            ProtocolName<Global> nextfullname = mc.getVisibleProtocolDeclFullName(next);
            if (rootfullname.equals(nextfullname)) {
                throw new ScribbleException(de.getSource(), "Recursive protocol dependencies not supported for delegation types: " + de);
            }
            ProtocolDecl nextgpd = checker.job.getContext().getModule(targetfullname.getPrefix()).getProtocolDecl(nextfullname.getSimpleName());
            Set tmp = ((GProtocolDeclDel)nextgpd.del()).getProtocolDeclContext().getDependencyMap().getDependencies().values().stream().flatMap(v -> v.keySet().stream()).filter(n -> !seen.contains(n)).collect(Collectors.toSet());
            todo.addAll(tmp);
        }
    }
}

