/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.del.local;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.InteractionNode;
import org.scribble.ast.ScribNode;
import org.scribble.ast.local.LInteractionNode;
import org.scribble.ast.local.LInteractionSeq;
import org.scribble.ast.local.LRecursion;
import org.scribble.del.InteractionSeqDel;
import org.scribble.del.ScribDelBase;
import org.scribble.main.ScribbleException;
import org.scribble.model.MState;
import org.scribble.model.endpoint.EState;
import org.scribble.visit.ProtocolDefInliner;
import org.scribble.visit.context.EGraphBuilder;
import org.scribble.visit.context.ProjectedChoiceDoPruner;
import org.scribble.visit.context.RecRemover;
import org.scribble.visit.env.InlineProtocolEnv;
import org.scribble.visit.wf.ReachabilityChecker;
import org.scribble.visit.wf.env.ReachabilityEnv;

public class LInteractionSeqDel
extends InteractionSeqDel {
    @Override
    public ScribNode leaveProjectedChoiceDoPruning(ScribNode parent, ScribNode child, ProjectedChoiceDoPruner pruner, ScribNode visited) throws ScribbleException {
        LInteractionSeq lc = (LInteractionSeq)visited;
        List actions = lc.getInteractions().stream().filter(li -> li != null).collect(Collectors.toList());
        return lc.reconstruct(actions);
    }

    @Override
    public ScribNode leaveProtocolInlining(ScribNode parent, ScribNode child, ProtocolDefInliner inl, ScribNode visited) throws ScribbleException {
        LInteractionSeq lis = (LInteractionSeq)visited;
        LinkedList<LInteractionNode> lins = new LinkedList<LInteractionNode>();
        for (LInteractionNode li : lis.getInteractions()) {
            ScribNode inlined = ((InlineProtocolEnv)li.del().env()).getTranslation();
            if (inlined instanceof LInteractionSeq) {
                lins.addAll(((LInteractionSeq)inlined).getInteractions());
                continue;
            }
            lins.add((LInteractionNode)inlined);
        }
        LInteractionSeq inlined = AstFactoryImpl.FACTORY.LInteractionSeq(lis.getSource(), lins);
        inl.pushEnv(((InlineProtocolEnv)inl.popEnv()).setTranslation(inlined));
        return ScribDelBase.popAndSetVisitorEnv(this, inl, lis);
    }

    public LInteractionSeq visitForReachabilityChecking(ReachabilityChecker checker, LInteractionSeq child) throws ScribbleException {
        LinkedList<LInteractionNode> visited = new LinkedList<LInteractionNode>();
        for (InteractionNode interactionNode : child.getInteractions()) {
            ReachabilityEnv re = (ReachabilityEnv)checker.peekEnv();
            if (!re.isSequenceable()) {
                throw new ScribbleException(interactionNode.getSource(), "Invalid/unreachable sequence to: " + interactionNode);
            }
            visited.add((LInteractionNode)interactionNode.accept(checker));
        }
        return child;
    }

    public LInteractionSeq visitForFsmConversion(EGraphBuilder conv, LInteractionSeq child) throws ScribbleException {
        EState entry = (EState)conv.util.getEntry();
        EState exit = (EState)conv.util.getExit();
        for (int i = 0; i < child.getInteractions().size(); ++i) {
            if (i == child.getInteractions().size() - 1) {
                conv.util.setExit(exit);
                child.getInteractions().get(i).accept(conv);
                continue;
            }
            MState tmp = conv.util.newState(Collections.emptySet());
            conv.util.setExit(tmp);
            child.getInteractions().get(i).accept(conv);
            conv.util.setEntry(conv.util.getExit());
        }
        conv.util.setEntry(entry);
        return child;
    }

    @Override
    public LInteractionSeq leaveRecRemoval(ScribNode parent, ScribNode child, RecRemover rem, ScribNode visited) throws ScribbleException {
        LInteractionSeq lis = (LInteractionSeq)visited;
        List<LInteractionNode> lins = lis.getInteractions().stream().flatMap(li -> li instanceof LRecursion && rem.toRemove(((LRecursion)li).recvar.toName()) ? ((LRecursion)li).getBlock().getInteractionSeq().getInteractions().stream() : Stream.of(li)).collect(Collectors.toList());
        return AstFactoryImpl.FACTORY.LInteractionSeq(lis.getSource(), lins);
    }
}

