/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.main;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.ast.Module;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOInterfacesGenerator;
import org.scribble.del.local.LProtocolDeclDel;
import org.scribble.main.JobContext;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.LProtocolName;
import org.scribble.sesstype.name.ModuleName;
import org.scribble.sesstype.name.Role;
import org.scribble.visit.AstVisitor;
import org.scribble.visit.InlinedProtocolUnfolder;
import org.scribble.visit.ProtocolDefInliner;
import org.scribble.visit.context.ModuleContextBuilder;
import org.scribble.visit.context.ProjectedChoiceDoPruner;
import org.scribble.visit.context.ProjectedChoiceSubjectFixer;
import org.scribble.visit.context.ProjectedRoleDeclFixer;
import org.scribble.visit.context.Projector;
import org.scribble.visit.context.ProtocolDeclContextBuilder;
import org.scribble.visit.util.RoleCollector;
import org.scribble.visit.validation.GProtocolValidator;
import org.scribble.visit.wf.DelegationProtocolRefChecker;
import org.scribble.visit.wf.ExplicitCorrelationChecker;
import org.scribble.visit.wf.NameDisambiguator;
import org.scribble.visit.wf.ReachabilityChecker;
import org.scribble.visit.wf.WFChoiceChecker;

public class Job {
    public final boolean debug;
    public final boolean useOldWf;
    public final boolean noProgress;
    public final boolean minEfsm;
    public final boolean fair;
    public final boolean noLocalChoiceSubjectCheck;
    public final boolean noAcceptCorrelationCheck;
    public final boolean noValidation;
    private final JobContext jcontext;

    public Job(boolean debug, Map<ModuleName, Module> parsed, ModuleName main, boolean useOldWF, boolean noLiveness, boolean minEfsm, boolean fair, boolean noLocalChoiceSubjectCheck, boolean noAcceptCorrelationCheck, boolean noValidation) {
        this.debug = debug;
        this.useOldWf = useOldWF;
        this.noProgress = noLiveness;
        this.minEfsm = minEfsm;
        this.fair = fair;
        this.noLocalChoiceSubjectCheck = noLocalChoiceSubjectCheck;
        this.noAcceptCorrelationCheck = noAcceptCorrelationCheck;
        this.noValidation = noValidation;
        this.jcontext = new JobContext(this, parsed, main);
    }

    public void checkWellFormedness() throws ScribbleException {
        this.runContextBuildingPasses();
        this.runUnfoldingPass();
        this.runWellFormednessPasses();
    }

    public void runContextBuildingPasses() throws ScribbleException {
        this.runVisitorPassOnAllModules(ModuleContextBuilder.class);
        this.runVisitorPassOnAllModules(NameDisambiguator.class);
        this.runVisitorPassOnAllModules(ProtocolDeclContextBuilder.class);
        this.runVisitorPassOnAllModules(DelegationProtocolRefChecker.class);
        this.runVisitorPassOnAllModules(RoleCollector.class);
        this.runVisitorPassOnAllModules(ProtocolDefInliner.class);
    }

    public void runUnfoldingPass() throws ScribbleException {
        this.runVisitorPassOnAllModules(InlinedProtocolUnfolder.class);
    }

    public void runWellFormednessPasses() throws ScribbleException {
        if (!this.noValidation) {
            this.runVisitorPassOnAllModules(WFChoiceChecker.class);
            this.runProjectionPasses();
            this.runVisitorPassOnAllModules(ReachabilityChecker.class);
            if (!this.useOldWf) {
                this.runVisitorPassOnAllModules(GProtocolValidator.class);
            }
        }
    }

    private void runProjectionPasses() throws ScribbleException {
        this.runVisitorPassOnAllModules(Projector.class);
        this.runProjectionContextBuildingPasses();
        if (!this.noAcceptCorrelationCheck) {
            this.runVisitorPassOnParsedModules(ExplicitCorrelationChecker.class);
        }
    }

    private void runProjectionContextBuildingPasses() throws ScribbleException {
        this.runVisitorPassOnProjectedModules(ModuleContextBuilder.class);
        this.runVisitorPassOnProjectedModules(ProtocolDeclContextBuilder.class);
        this.runVisitorPassOnProjectedModules(RoleCollector.class);
        this.runVisitorPassOnProjectedModules(ProjectedChoiceDoPruner.class);
        if (!this.noLocalChoiceSubjectCheck) {
            this.runVisitorPassOnProjectedModules(ProjectedChoiceSubjectFixer.class);
        }
        this.runVisitorPassOnProjectedModules(ProjectedRoleDeclFixer.class);
        this.runVisitorPassOnProjectedModules(ProtocolDefInliner.class);
        this.runVisitorPassOnProjectedModules(InlinedProtocolUnfolder.class);
    }

    public Map<LProtocolName, Module> getProjections(GProtocolName fullname, Role role) throws ScribbleException {
        Module root = this.jcontext.getProjection(fullname, role);
        Map dependencies = ((LProtocolDeclDel)root.getLocalProtocolDecls().get(0).del()).getProtocolDeclContext().getDependencyMap().getDependencies().get(role);
        return dependencies.keySet().stream().collect(Collectors.toMap(lpn -> lpn, lpn -> this.jcontext.getModule(lpn.getPrefix())));
    }

    public Map<String, String> generateSessionApi(GProtocolName fullname) throws ScribbleException {
        this.debugPrintPass("Running " + SessionApiGenerator.class + " for " + fullname);
        SessionApiGenerator sg = new SessionApiGenerator(this, fullname);
        Map<String, String> map = sg.generateApi();
        return map;
    }

    public Map<String, String> generateStateChannelApi(GProtocolName fullname, Role self, boolean subtypes) throws ScribbleException {
        this.debugPrintPass("Running " + StateChannelApiGenerator.class + " for " + fullname + "@" + self);
        StateChannelApiGenerator apigen = new StateChannelApiGenerator(this, fullname, self);
        IOInterfacesGenerator iogen = null;
        try {
            iogen = new IOInterfacesGenerator(apigen, subtypes);
        }
        catch (RuntimeScribbleException e) {
            this.warningPrintln("Skipping I/O Interface generation for: " + fullname + "\n  Cause: " + e.getMessage());
        }
        HashMap<String, String> api = new HashMap<String, String>();
        api.putAll(apigen.generateApi());
        if (iogen != null) {
            api.putAll(iogen.generateApi());
        }
        return api;
    }

    public void runVisitorPassOnAllModules(Class<? extends AstVisitor> c) throws ScribbleException {
        this.debugPrintPass("Running " + c + " on all modules:");
        this.runVisitorPass(this.jcontext.getFullModuleNames(), c);
    }

    public void runVisitorPassOnParsedModules(Class<? extends AstVisitor> c) throws ScribbleException {
        this.debugPrintPass("Running " + c + " on parsed modules:");
        this.runVisitorPass(this.jcontext.getParsedFullModuleNames(), c);
    }

    public void runVisitorPassOnProjectedModules(Class<? extends AstVisitor> c) throws ScribbleException {
        this.debugPrintPass("Running " + c + " on projected modules:");
        this.runVisitorPass(this.jcontext.getProjectedFullModuleNames(), c);
    }

    private void runVisitorPass(Set<ModuleName> modnames, Class<? extends AstVisitor> c) throws ScribbleException {
        try {
            Constructor<? extends AstVisitor> cons = c.getConstructor(Job.class);
            for (ModuleName modname : modnames) {
                AstVisitor nv = cons.newInstance(this);
                this.runVisitorOnModule(modname, nv);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void runVisitorOnModule(ModuleName modname, AstVisitor nv) throws ScribbleException {
        Module visited = (Module)this.jcontext.getModule(modname).accept(nv);
        this.jcontext.replaceModule(visited);
    }

    public JobContext getContext() {
        return this.jcontext;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void warningPrintln(String s) {
        System.err.println("[Warning] " + s);
    }

    public void debugPrintln(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }

    private void debugPrintPass(String s) {
        this.debugPrintln("\n[Step] " + s);
    }
}

