/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.main;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.ast.Module;
import org.scribble.ast.ProtocolDecl;
import org.scribble.ast.global.GProtocolDecl;
import org.scribble.main.Job;
import org.scribble.main.ScribbleException;
import org.scribble.model.endpoint.AutParser;
import org.scribble.model.endpoint.EGraph;
import org.scribble.model.global.SGraph;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.LProtocolName;
import org.scribble.sesstype.name.ModuleName;
import org.scribble.sesstype.name.Role;
import org.scribble.util.ScribUtil;
import org.scribble.visit.context.EGraphBuilder;
import org.scribble.visit.context.Projector;

public class JobContext {
    private final Job job;
    public final ModuleName main;
    private final Map<ModuleName, Module> parsed;
    private final Map<LProtocolName, Module> projected = new HashMap<LProtocolName, Module>();
    private final Map<LProtocolName, EGraph> fairEGraphs = new HashMap<LProtocolName, EGraph>();
    private final Map<GProtocolName, SGraph> fairSGraphs = new HashMap<GProtocolName, SGraph>();
    private final Map<LProtocolName, EGraph> unfairEGraphs = new HashMap<LProtocolName, EGraph>();
    private final Map<GProtocolName, SGraph> unfairSGraphs = new HashMap<GProtocolName, SGraph>();
    private final Map<LProtocolName, EGraph> minimisedEGraphs = new HashMap<LProtocolName, EGraph>();

    protected JobContext(Job job, Map<ModuleName, Module> parsed, ModuleName main) {
        this.job = job;
        this.parsed = new HashMap<ModuleName, Module>(parsed);
        this.main = main;
    }

    public Module getMainModule() {
        return this.getModule(this.main);
    }

    public Set<ModuleName> getFullModuleNames() {
        HashSet<ModuleName> modnames = new HashSet<ModuleName>();
        modnames.addAll(this.getParsedFullModuleNames());
        modnames.addAll(this.getProjectedFullModuleNames());
        return modnames;
    }

    public Set<ModuleName> getParsedFullModuleNames() {
        HashSet<ModuleName> modnames = new HashSet<ModuleName>();
        modnames.addAll(this.parsed.keySet());
        return modnames;
    }

    public Set<ModuleName> getProjectedFullModuleNames() {
        return this.projected.keySet().stream().map(lpn -> lpn.getPrefix()).collect(Collectors.toSet());
    }

    private boolean isParsedModule(ModuleName fullname) {
        return this.parsed.containsKey(fullname);
    }

    private boolean isProjectedModule(ModuleName fullname) {
        return this.getProjectedFullModuleNames().contains(fullname);
    }

    public Module getModule(ModuleName fullname) {
        if (this.isParsedModule(fullname)) {
            return this.parsed.get(fullname);
        }
        if (this.isProjectedModule(fullname)) {
            return this.projected.get(this.projected.keySet().stream().filter(lpn -> lpn.getPrefix().equals(fullname)).collect(Collectors.toList()).get(0));
        }
        throw new RuntimeException("Unknown module: " + fullname);
    }

    protected void replaceModule(Module module) {
        ModuleName fullname = module.getFullModuleName();
        if (this.isParsedModule(fullname)) {
            this.parsed.put(fullname, module);
        } else if (this.isProjectedModule(fullname)) {
            this.addProjection(module);
        } else {
            throw new RuntimeException("Unknown module: " + fullname);
        }
    }

    public void addProjections(Map<GProtocolName, Map<Role, Module>> projections) {
        for (GProtocolName gpn : projections.keySet()) {
            Map<Role, Module> mods = projections.get(gpn);
            for (Role role : mods.keySet()) {
                this.addProjection(mods.get(role));
            }
        }
    }

    private void addProjection(Module mod) {
        LProtocolName lpn = (LProtocolName)mod.getProtocolDecls().get(0).getFullMemberName(mod);
        this.projected.put(lpn, mod);
    }

    public Module getProjection(GProtocolName fullname, Role role) throws ScribbleException {
        Module proj = this.projected.get(Projector.projectFullProtocolName(fullname, role));
        if (proj == null) {
            throw new ScribbleException("Projection not found: " + fullname + ", " + role);
        }
        return proj;
    }

    protected void addEGraph(LProtocolName fullname, EGraph graph) {
        this.fairEGraphs.put(fullname, graph);
    }

    public EGraph getEGraph(GProtocolName fullname, Role role) throws ScribbleException {
        LProtocolName fulllpn = Projector.projectFullProtocolName(fullname, role);
        EGraph graph = this.fairEGraphs.get(fulllpn);
        if (graph == null) {
            Module proj = this.getProjection(fullname, role);
            EGraphBuilder builder = new EGraphBuilder(this.job);
            proj.accept(builder);
            graph = builder.util.finalise();
            this.addEGraph(fulllpn, graph);
        }
        return graph;
    }

    protected void addUnfairEGraph(LProtocolName fullname, EGraph graph) {
        this.unfairEGraphs.put(fullname, graph);
    }

    public EGraph getUnfairEGraph(GProtocolName fullname, Role role) throws ScribbleException {
        LProtocolName fulllpn = Projector.projectFullProtocolName(fullname, role);
        EGraph unfair = this.unfairEGraphs.get(fulllpn);
        if (unfair == null) {
            unfair = this.getEGraph((GProtocolName)fullname, (Role)role).init.unfairTransform().toGraph();
            this.addUnfairEGraph(fulllpn, unfair);
        }
        return unfair;
    }

    protected void addSGraph(GProtocolName fullname, SGraph graph) {
        this.fairSGraphs.put(fullname, graph);
    }

    public SGraph getSGraph(GProtocolName fullname) throws ScribbleException {
        SGraph graph = this.fairSGraphs.get(fullname);
        if (graph == null) {
            GProtocolDecl gpd = (GProtocolDecl)this.getModule(fullname.getPrefix()).getProtocolDecl(fullname.getSimpleName());
            Map<Role, EGraph> egraphs = this.getEGraphsForSGraphBuilding(fullname, gpd, true);
            boolean explicit = gpd.modifiers.contains((Object)ProtocolDecl.Modifiers.EXPLICIT);
            graph = SGraph.buildSGraph(egraphs, explicit, this.job, fullname);
            this.addSGraph(fullname, graph);
        }
        return graph;
    }

    private Map<Role, EGraph> getEGraphsForSGraphBuilding(GProtocolName fullname, GProtocolDecl gpd, boolean fair) throws ScribbleException {
        HashMap<Role, EGraph> egraphs = new HashMap<Role, EGraph>();
        for (Role self : gpd.header.roledecls.getRoles()) {
            egraphs.put(self, fair ? this.getEGraph(fullname, self) : this.getUnfairEGraph(fullname, self));
        }
        return egraphs;
    }

    protected void addUnfairSGraph(GProtocolName fullname, SGraph graph) {
        this.unfairSGraphs.put(fullname, graph);
    }

    public SGraph getUnfairSGraph(GProtocolName fullname) throws ScribbleException {
        SGraph graph = this.unfairSGraphs.get(fullname);
        if (graph == null) {
            GProtocolDecl gpd = (GProtocolDecl)this.getModule(fullname.getPrefix()).getProtocolDecl(fullname.getSimpleName());
            Map<Role, EGraph> egraphs = this.getEGraphsForSGraphBuilding(fullname, gpd, false);
            boolean explicit = gpd.modifiers.contains((Object)ProtocolDecl.Modifiers.EXPLICIT);
            graph = SGraph.buildSGraph(egraphs, explicit, this.job, fullname);
            this.addUnfairSGraph(fullname, graph);
        }
        return graph;
    }

    protected void addMinimisedEGraph(LProtocolName fullname, EGraph graph) {
        this.minimisedEGraphs.put(fullname, graph);
    }

    public EGraph getMinimisedEGraph(GProtocolName fullname, Role role) throws ScribbleException {
        LProtocolName fulllpn = Projector.projectFullProtocolName(fullname, role);
        EGraph minimised = this.minimisedEGraphs.get(fulllpn);
        if (minimised == null) {
            String aut = JobContext.runAut(this.getEGraph((GProtocolName)fullname, (Role)role).init.toAut(), fulllpn + ".aut");
            minimised = new AutParser().parse(aut);
            this.addMinimisedEGraph(fulllpn, minimised);
        }
        return minimised;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runAut(String fsm, String aut) throws ScribbleException {
        String tmpName = aut + ".tmp";
        File tmp = new File(tmpName);
        if (tmp.exists()) {
            throw new RuntimeException("Cannot overwrite: " + tmpName);
        }
        try {
            ScribUtil.writeToFile(tmpName, fsm);
            String[] res = ScribUtil.runProcess("ltsconvert", "-ebisim", "-iaut", "-oaut", tmpName);
            if (!res[1].isEmpty()) {
                throw new RuntimeException(res[1]);
            }
            String string = res[0];
            return string;
        }
        finally {
            tmp.delete();
        }
    }
}

