/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.main.resource;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import org.scribble.main.ScribbleException;
import org.scribble.main.resource.FileResource;
import org.scribble.main.resource.ResourceLocator;

public class DirectoryResourceLocator
extends ResourceLocator {
    private List<Path> impaths;

    public DirectoryResourceLocator(List<Path> paths) {
        this.impaths = new LinkedList<Path>(paths);
    }

    @Override
    public FileResource getResource(Path path) throws ScribbleException {
        for (Path impath : this.impaths) {
            Path prefixedpath = impath.resolve(path);
            if (!Files.exists(prefixedpath, new LinkOption[0])) continue;
            return DirectoryResourceLocator.openFileInputStreamResource(prefixedpath);
        }
        throw new ScribbleException("Couldn't open resource: " + path);
    }

    public static FileResource getResourceByFullPath(Path path) throws ScribbleException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new ScribbleException("File couldn't be opened: " + path);
        }
        return DirectoryResourceLocator.openFileInputStreamResource(path);
    }

    private static FileResource openFileInputStreamResource(Path path) throws ScribbleException {
        try {
            return new FileResource(path, Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new ScribbleException(e);
        }
    }
}

