/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model;

import java.util.Collections;
import java.util.Set;
import org.scribble.main.ScribbleException;
import org.scribble.model.MAction;
import org.scribble.model.MState;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.sesstype.name.RecVar;

public abstract class GraphBuilderUtil<L, A extends MAction<K>, S extends MState<L, A, S, K>, K extends ProtocolKind> {
    protected S entry;
    protected S exit;

    public void reset() {
        this.entry = this.newState(Collections.emptySet());
        this.exit = this.newState(Collections.emptySet());
    }

    public abstract S newState(Set<RecVar> var1);

    public void addEntryLabel(L lab) {
        ((MState)this.entry).addLabel(lab);
    }

    public void addEdge(S s, A a, S succ) {
        this.addEdgeAux(s, a, succ);
    }

    protected final void addEdgeAux(S s, A a, S succ) {
        ((MState)s).addEdge(a, succ);
    }

    protected final void removeEdgeAux(S s, A a, S succ) throws ScribbleException {
        ((MState)s).removeEdge(a, succ);
    }

    public S getEntry() {
        return this.entry;
    }

    public void setEntry(S entry) {
        this.entry = entry;
    }

    public S getExit() {
        return this.exit;
    }

    public void setExit(S exit) {
        this.exit = exit;
    }
}

