/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.model.MAction;
import org.scribble.model.MPrettyPrint;
import org.scribble.model.MState;
import org.scribble.sesstype.kind.ProtocolKind;

public abstract class MPrettyState<L, A extends MAction<K>, S extends MPrettyState<L, A, S, K>, K extends ProtocolKind>
extends MState<L, A, S, K>
implements MPrettyPrint {
    public MPrettyState(Set<L> labs) {
        super(labs);
    }

    public String toLongString() {
        String s = "\"" + this.id + "\":[";
        Iterator ss = this.succs.iterator();
        s = s + this.actions.stream().map(a -> a + "=\"" + ((MPrettyState)ss.next()).id + "\"").collect(Collectors.joining(", "));
        return s + "]";
    }

    @Override
    public final String toDot() {
        String s = "digraph G {\ncompound = true;\n";
        s = s + this.toDot(new HashSet<MPrettyState<L, A, S, K>>());
        return s + "\n}";
    }

    protected final String toDot(Set<MPrettyState<L, A, S, K>> seen) {
        seen.add(this);
        String dot = this.toNodeDot();
        for (int i = 0; i < this.actions.size(); ++i) {
            MAction a = (MAction)this.actions.get(i);
            MPrettyState s = (MPrettyState)this.succs.get(i);
            dot = dot + "\n" + this.toEdgeDot(a, s);
            if (seen.contains(s)) continue;
            dot = dot + "\n" + s.toDot(seen);
        }
        return dot;
    }

    protected final String toEdgeDot(String src, String dest, String lab) {
        return src + " -> " + dest + " [ " + lab + " ];";
    }

    protected String toNodeDot() {
        return this.getDotNodeId() + " [ " + this.getNodeLabel() + " ];";
    }

    protected String getNodeLabel() {
        String labs = this.labs.toString();
        return "label=\"" + this.id + ": " + labs.substring(1, labs.length() - 1) + "\"";
    }

    protected String getDotNodeId() {
        return "\"" + this.id + "\"";
    }

    protected String toEdgeDot(A msg, S next) {
        return this.toEdgeDot(this.getDotNodeId(), ((MPrettyState)next).getDotNodeId(), ((MPrettyState)next).getEdgeLabel(msg));
    }

    protected String getEdgeLabel(A msg) {
        return "label=\"" + msg + "\"";
    }

    @Override
    public final String toAut() {
        HashSet<MPrettyState<L, A, S, K>> all = new HashSet<MPrettyState<L, A, S, K>>();
        all.add(this);
        all.addAll(MPrettyState.getReachableStates(this));
        String aut = "";
        int edges = 0;
        HashSet<Integer> seen = new HashSet<Integer>();
        for (MPrettyState mPrettyState : all) {
            if (seen.contains(mPrettyState.id)) continue;
            seen.add(mPrettyState.id);
            Iterator as = mPrettyState.getAllActions().iterator();
            Iterator ss = mPrettyState.getAllSuccessors().iterator();
            while (as.hasNext()) {
                MAction a = (MAction)as.next();
                MPrettyState succ = (MPrettyState)ss.next();
                String msg = a.toStringWithMessageIdHack();
                aut = aut + "\n(" + mPrettyState.id + ",\"" + msg + "\"," + succ.id + ")";
                ++edges;
            }
        }
        return "des (" + this.id + "," + edges + "," + all.size() + ")" + aut + "\n";
    }

    @Override
    public int hashCode() {
        int hash = 71;
        hash = 31 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MPrettyState)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        return Integer.toString(this.id);
    }
}

