/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.main.ScribbleException;
import org.scribble.model.MAction;
import org.scribble.sesstype.kind.ProtocolKind;

public abstract class MState<L, A extends MAction<K>, S extends MState<L, A, S, K>, K extends ProtocolKind> {
    private static int count = 0;
    public final int id = count++;
    protected final Set<L> labs;
    protected final List<A> actions;
    protected final List<S> succs;

    public MState(Set<L> labs) {
        this.labs = new HashSet<L>(labs);
        this.actions = new LinkedList<A>();
        this.succs = new LinkedList<S>();
    }

    protected final void addLabel(L lab) {
        this.labs.add(lab);
    }

    public final Set<L> getLabels() {
        return Collections.unmodifiableSet(this.labs);
    }

    public final void addEdge(A a, S s) {
        Iterator<A> as = this.actions.iterator();
        Iterator<S> ss = this.succs.iterator();
        while (as.hasNext()) {
            MAction tmpa = (MAction)as.next();
            MState tmps = (MState)ss.next();
            if (!tmpa.equals(a) || !tmps.equals(s)) continue;
            return;
        }
        this.actions.add(a);
        this.succs.add(s);
    }

    protected final void removeEdge(A a, S s) throws ScribbleException {
        Iterator<A> ia = this.actions.iterator();
        Iterator<S> is = this.succs.iterator();
        while (ia.hasNext()) {
            MAction tmpa = (MAction)ia.next();
            MState tmps = (MState)is.next();
            if (!tmpa.equals(a) || !tmps.equals(s)) continue;
            ia.remove();
            is.remove();
            return;
        }
        throw new ScribbleException("No such transition to remove: " + a + "->" + s);
    }

    public final List<A> getActions() {
        HashSet<A> as = new HashSet<A>(this.actions);
        if (as.size() != this.actions.size()) {
            throw new RuntimeScribbleException("[TODO] Non-deterministic state: " + this.actions + "  (Try -minlts if available)");
        }
        return this.getAllActions();
    }

    public final List<A> getAllActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public final boolean hasAction(A a) {
        return this.actions.contains(a);
    }

    public final S getSuccessor(A a) {
        HashSet<A> as = new HashSet<A>(this.actions);
        if (as.size() != this.actions.size()) {
            throw new RuntimeException("FIXME: " + this.actions);
        }
        return (S)((MState)this.getSuccessors(a).get(0));
    }

    public final List<S> getSuccessors() {
        HashSet<A> as = new HashSet<A>(this.actions);
        if (as.size() != this.actions.size()) {
            throw new RuntimeScribbleException("[TODO] Non-deterministic state: " + this.actions + "  (Try -minlts if available)");
        }
        return this.getAllSuccessors();
    }

    public final List<S> getSuccessors(A a) {
        return IntStream.range(0, this.actions.size()).filter(i -> ((MAction)this.actions.get(i)).equals(a)).mapToObj(i -> (MState)this.succs.get(i)).collect(Collectors.toList());
    }

    public final List<S> getAllSuccessors() {
        return Collections.unmodifiableList(this.succs);
    }

    public final boolean isTerminal() {
        return this.actions.isEmpty();
    }

    public static <L, A extends MAction<K>, S extends MState<L, A, S, K>, K extends ProtocolKind> S getTerminal(S start) {
        if (start.isTerminal()) {
            return start;
        }
        Set terms = MState.getReachableStates(start).stream().filter(s -> s.isTerminal()).collect(Collectors.toSet());
        if (terms.size() > 1) {
            throw new RuntimeException("Shouldn't get in here: " + terms);
        }
        return (S)(terms.isEmpty() ? null : (MState)terms.iterator().next());
    }

    public boolean canReach(MState<L, A, S, K> s) {
        return MState.getReachableStates(this).contains(s);
    }

    public static <L, A extends MAction<K>, S extends MState<L, A, S, K>, K extends ProtocolKind> Set<S> getReachableStates(MState<L, A, S, K> start) {
        HashMap<Integer, MState> all = new HashMap<Integer, MState>();
        LinkedHashMap<Integer, MState> todo = new LinkedHashMap<Integer, MState>();
        todo.put(start.id, start);
        while (!todo.isEmpty()) {
            Iterator i = todo.values().iterator();
            MState next = (MState)i.next();
            todo.remove(next.id);
            for (MState s : next.getAllSuccessors()) {
                if (all.containsKey(s.id)) continue;
                all.put(s.id, s);
                todo.put(s.id, s);
            }
        }
        return new HashSet(all.values());
    }

    public static <L, A extends MAction<K>, S extends MState<L, A, S, K>, K extends ProtocolKind> Set<A> getReachableActions(MState<L, A, S, K> start) {
        HashSet<MState<L, A, S, K>> all = new HashSet<MState<L, A, S, K>>();
        all.add(start);
        all.addAll(MState.getReachableStates(start));
        HashSet<A> as = new HashSet<A>();
        for (MState mState : all) {
            as.addAll(mState.getAllActions());
        }
        return as;
    }

    public int hashCode() {
        int hash = 73;
        hash = 31 * hash + this.id;
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MState)) {
            return false;
        }
        return ((MState)o).canEquals(this) && this.id == ((MState)o).id;
    }

    protected abstract boolean canEquals(MState<?, ?, ?, ?> var1);

    public String toString() {
        return Integer.toString(this.id);
    }
}

