/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.endpoint;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.model.endpoint.EGraph;
import org.scribble.model.endpoint.EGraphBuilderUtil;
import org.scribble.model.endpoint.EState;
import org.scribble.model.endpoint.actions.EAccept;
import org.scribble.model.endpoint.actions.EAction;
import org.scribble.model.endpoint.actions.EConnect;
import org.scribble.model.endpoint.actions.EDisconnect;
import org.scribble.model.endpoint.actions.EReceive;
import org.scribble.model.endpoint.actions.ESend;
import org.scribble.model.endpoint.actions.EWrapClient;
import org.scribble.model.endpoint.actions.EWrapServer;
import org.scribble.sesstype.Payload;
import org.scribble.sesstype.name.DataType;
import org.scribble.sesstype.name.MessageId;
import org.scribble.sesstype.name.MessageSigName;
import org.scribble.sesstype.name.Op;
import org.scribble.sesstype.name.Role;

public class AutParser {
    public EGraph parse(String aut) {
        int i;
        HashMap<Integer, LinkedList<String>> as = new HashMap<Integer, LinkedList<String>>();
        HashMap<Integer, LinkedList<Integer>> succs = new HashMap<Integer, LinkedList<Integer>>();
        int init = -1;
        try {
            BufferedReader br = new BufferedReader(new StringReader(aut));
            String line = br.readLine();
            if (line == null || !line.startsWith("des (") || !line.endsWith(")")) {
                throw new RuntimeException("Unexpected first line: " + line);
            }
            String[] first = line.substring("des (".length(), line.length() - 1).split(",");
            if (first.length != 3) {
                throw new RuntimeException("Unexpected first line: " + line);
            }
            init = Integer.parseInt(first[0]);
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("(") || !line.endsWith(")")) {
                    throw new RuntimeException("Unexpected line: " + line);
                }
                String[] read = new String[]{line.substring(1, line.indexOf(44)), line.substring(line.indexOf(44) + 1, line.lastIndexOf(44)), line.substring(line.lastIndexOf(44) + 1, line.length() - 1)};
                int s = Integer.parseInt(read[0]);
                String a = read[1].substring(1, read[1].length() - 1);
                int succ = Integer.parseInt(read[2]);
                LinkedList<String> tmp1 = (LinkedList<String>)as.get(s);
                LinkedList<Integer> tmp2 = (LinkedList<Integer>)succs.get(s);
                if (tmp1 == null) {
                    tmp1 = new LinkedList<String>();
                    as.put(s, tmp1);
                    tmp2 = new LinkedList<Integer>();
                    succs.put(s, tmp2);
                }
                tmp1.add(a);
                tmp2.add(succ);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Set allSuccs = succs.values().stream().flatMap(j -> j.stream()).collect(Collectors.toSet());
        int term = -1;
        Set terms = allSuccs.stream().filter(j -> !succs.containsKey(j)).collect(Collectors.toSet());
        if (terms.size() > 0) {
            term = (Integer)terms.iterator().next();
        }
        EGraphBuilderUtil builder = new EGraphBuilderUtil();
        builder.reset();
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        map.put(init, builder.getEntry());
        if (term != -1) {
            map.put(term, builder.getExit());
        }
        map.put(init, builder.getEntry());
        Iterator iterator = as.keySet().iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (i == init || i == term) continue;
            map.put(i, builder.newState(Collections.emptySet()));
        }
        iterator = succs.keySet().iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (map.containsKey(i) || i == init || i == term) continue;
            map.put(i, builder.newState(Collections.emptySet()));
        }
        iterator = as.keySet().iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            EState s = (EState)map.get(i);
            List tmp1 = (List)as.get(i);
            List tmp2 = (List)succs.get(i);
            if (tmp1 == null) continue;
            Iterator is = tmp2.iterator();
            for (String a : tmp1) {
                int succ = (Integer)is.next();
                builder.addEdge(s, AutParser.parseIOAction(a), (EState)map.get(succ));
            }
        }
        return new EGraph((EState)builder.getEntry(), (EState)builder.getExit());
    }

    private static EAction parseIOAction(String a) {
        int j;
        String[] pay = null;
        int i = a.indexOf("!");
        if (i != -1) {
            j = i + 1;
            if (a.charAt(j) == '!') {
                ++j;
                if (a.charAt(i - 1) == '(') {
                    if (a.charAt(j + 1) != ')') {
                        throw new RuntimeException("Shouldn't get in here: " + a);
                    }
                    --i;
                    ++j;
                }
            }
        } else {
            i = a.indexOf("?");
            if (i != -1) {
                j = i + 1;
                if (a.charAt(j) == '?') {
                    ++j;
                    if (a.charAt(i - 1) == '(') {
                        if (a.charAt(j + 1) != ')') {
                            throw new RuntimeException("Shouldn't get in here: " + a);
                        }
                        --i;
                        ++j;
                    }
                }
            } else {
                i = a.indexOf(47);
                if (i != -1) {
                    if (a.charAt(i - 1) != '-' || a.charAt(i + 1) != '-') {
                        throw new RuntimeException("Shouldn't get in here: " + a);
                    }
                    j = i + 2;
                    --i;
                } else {
                    throw new RuntimeException("[TODO] aut parsing not supported for: " + a);
                }
            }
        }
        String action = a.substring(i, j);
        String peer = a.substring(0, i);
        int k = a.indexOf("(");
        String msg = a.substring(j, k);
        String p = a.substring(k + 1, a.length() - 1);
        if (!p.isEmpty()) {
            pay = p.split(",");
        }
        switch (action) {
            case "!": {
                Payload payload = pay != null ? new Payload(Arrays.asList(pay).stream().map(pe -> new DataType((String)pe)).collect(Collectors.toList())) : Payload.EMPTY_PAYLOAD;
                return new ESend(new Role(peer), AutParser.getMessageIdHack(msg), payload);
            }
            case "?": {
                Payload payload = pay != null ? new Payload(Arrays.asList(pay).stream().map(pe -> new DataType((String)pe)).collect(Collectors.toList())) : Payload.EMPTY_PAYLOAD;
                return new EReceive(new Role(peer), AutParser.getMessageIdHack(msg), payload);
            }
            case "!!": {
                Payload payload = pay != null ? new Payload(Arrays.asList(pay).stream().map(pe -> new DataType((String)pe)).collect(Collectors.toList())) : Payload.EMPTY_PAYLOAD;
                return new EConnect(new Role(peer), AutParser.getMessageIdHack(msg), payload);
            }
            case "??": {
                Payload payload = pay != null ? new Payload(Arrays.asList(pay).stream().map(pe -> new DataType((String)pe)).collect(Collectors.toList())) : Payload.EMPTY_PAYLOAD;
                return new EAccept(new Role(peer), AutParser.getMessageIdHack(msg), payload);
            }
            case "(!!)": {
                return new EWrapClient(new Role(peer));
            }
            case "(??)": {
                return new EWrapServer(new Role(peer));
            }
            case "-/-": {
                return new EDisconnect(new Role(peer));
            }
        }
        throw new RuntimeException("[TODO] aut parsing not supported for: " + msg);
    }

    private static MessageId<?> getMessageIdHack(String msg) {
        return msg.startsWith("^") ? new MessageSigName(msg.substring(1)) : new Op(msg);
    }
}

