/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.endpoint;

import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.scribble.main.ScribbleException;
import org.scribble.model.GraphBuilderUtil;
import org.scribble.model.endpoint.EGraph;
import org.scribble.model.endpoint.EState;
import org.scribble.model.endpoint.IntermediateContinueEdge;
import org.scribble.model.endpoint.actions.EAction;
import org.scribble.sesstype.kind.Local;
import org.scribble.sesstype.name.RecVar;

public class EGraphBuilderUtil
extends GraphBuilderUtil<RecVar, EAction, EState, Local> {
    private final Map<RecVar, Deque<EState>> recvars = new HashMap<RecVar, Deque<EState>>();
    private final Map<RecVar, Deque<List<EAction>>> enacting = new HashMap<RecVar, Deque<List<EAction>>>();
    private final Map<EState, Map<RecVar, List<EAction>>> enactingMap = new HashMap<EState, Map<RecVar, List<EAction>>>();
    private final Deque<List<EState>> pred = new LinkedList<List<EState>>();
    private final Deque<List<EAction>> prev = new LinkedList<List<EAction>>();

    public EGraphBuilderUtil() {
        this.clear();
    }

    protected void clear() {
        this.recvars.clear();
        this.enacting.clear();
        this.pred.clear();
        this.prev.clear();
        this.pred.push(new LinkedList());
        this.prev.push(new LinkedList());
        this.enactingMap.clear();
    }

    @Override
    public void reset() {
        this.clear();
        super.reset();
    }

    @Override
    public EState newState(Set<RecVar> labs) {
        return new EState(labs);
    }

    @Override
    public void addEdge(EState s, EAction a, EState succ) {
        this.addEdgeAux(s, a, succ);
        this.pred.pop();
        this.prev.pop();
        this.pred.push(new LinkedList<EState>(Arrays.asList(s)));
        this.prev.push(new LinkedList<EAction>(Arrays.asList(a)));
        for (Deque<List<EAction>> ens : this.enacting.values()) {
            List<EAction> tmp;
            if (ens.isEmpty() || !(tmp = ens.peek()).isEmpty()) continue;
            tmp.add(a);
        }
    }

    public void enterChoice() {
        this.pred.push(new LinkedList());
        this.prev.push(new LinkedList());
        for (RecVar rv : this.enacting.keySet()) {
            Deque<List<EAction>> tmp = this.enacting.get(rv);
            tmp.push(new LinkedList());
        }
    }

    public void leaveChoice() {
        List<EState> pred = this.pred.pop();
        List<EAction> prev = this.prev.pop();
        if (!pred.isEmpty()) {
            this.pred.pop();
            this.prev.pop();
            this.pred.push(pred);
            this.prev.push(prev);
        }
        for (RecVar rv : this.enacting.keySet()) {
            List<EAction> pop = this.enacting.get(rv).pop();
            List<EAction> peek = this.enacting.get(rv).peek();
            if (!peek.isEmpty()) continue;
            peek.addAll(pop);
        }
    }

    public void pushChoiceBlock() {
        this.pred.push(null);
        this.prev.push(null);
        for (RecVar rv : this.enacting.keySet()) {
            Deque<List<EAction>> tmp = this.enacting.get(rv);
            tmp.push(new LinkedList());
        }
    }

    public void popChoiceBlock() {
        List<EState> pred = this.pred.pop();
        List<EAction> prev = this.prev.pop();
        if (pred != null) {
            List<EState> peek1 = this.pred.peek();
            if (peek1 == null) {
                this.pred.pop();
                peek1 = new LinkedList<EState>();
                this.pred.push(peek1);
            }
            peek1.addAll(pred);
        }
        if (prev != null) {
            List<EAction> peek2 = this.prev.peek();
            if (peek2 == null) {
                this.prev.pop();
                peek2 = new LinkedList<EAction>();
                this.prev.push(peek2);
            }
            peek2.addAll(prev);
        }
        for (RecVar rv : this.enacting.keySet()) {
            List<EAction> pop = this.enacting.get(rv).pop();
            List<EAction> peek = this.enacting.get(rv).peek();
            peek.addAll(pop);
        }
    }

    public void pushRecursionEntry(RecVar recvar, EState entry) {
        Deque<EState> tmp = this.recvars.get(recvar);
        if (tmp == null) {
            tmp = new LinkedList<EState>();
            this.recvars.put(recvar, tmp);
        }
        tmp.push(entry);
        Deque<List<EAction>> tmp2 = this.enacting.get(recvar);
        if (tmp2 == null) {
            tmp2 = new LinkedList<List<EAction>>();
            this.enacting.put(recvar, tmp2);
        }
        tmp2.push(new LinkedList());
    }

    public void popRecursionEntry(RecVar recvar) {
        EState curr;
        Map<RecVar, List<EAction>> tmp;
        this.recvars.get(recvar).pop();
        List<EAction> pop = this.enacting.get(recvar).pop();
        if (this.enacting.get(recvar).isEmpty()) {
            this.enacting.remove(recvar);
        }
        if ((tmp = this.enactingMap.get(curr = (EState)this.getEntry())) == null) {
            tmp = new HashMap<RecVar, List<EAction>>();
            this.enactingMap.put(curr, tmp);
        }
        tmp.put(recvar, pop);
    }

    public boolean isUnguardedInChoice() {
        return this.pred.peek() == null;
    }

    public void addContinueEdge(EState s, RecVar rv) {
        EState entry = this.getRecursionEntry(rv);
        this.addEdgeAux(s, new IntermediateContinueEdge(rv), entry);
    }

    public void addRecursionEdge(EState s, EAction a, EState succ) {
        this.addEdgeAux(s, a, succ);
        for (Deque<List<EAction>> ens : this.enacting.values()) {
            List<EAction> tmp;
            if (ens.isEmpty() || !(tmp = ens.peek()).isEmpty()) continue;
            tmp.add(a);
        }
    }

    public void removeEdgeFromPredecessor(EState s, EAction a) throws ScribbleException {
        this.removeEdgeAux(s, a, this.getEntry());
        Iterator<EState> preds = this.pred.peek().iterator();
        Iterator<EAction> prevs = this.prev.peek().iterator();
        while (preds.hasNext()) {
            EState nexts = preds.next();
            EAction nexta = prevs.next();
            if (!nexts.equals(s) || !nexta.equals(a)) continue;
            preds.remove();
            prevs.remove();
            return;
        }
        throw new RuntimeException("Shouldn't get in here: " + s + ", " + a);
    }

    public List<EState> getPredecessors() {
        return new LinkedList<EState>((Collection)this.pred.peek());
    }

    public List<EAction> getPreviousActions() {
        return new LinkedList<EAction>((Collection)this.prev.peek());
    }

    public EState getRecursionEntry(RecVar recvar) {
        return this.recvars.get(recvar).peek();
    }

    public EGraph finalise() {
        EState res = new EState(((EState)this.entry).getLabels());
        EState resTerm = new EState(((EState)this.exit).getLabels());
        HashMap<EState, EState> map = new HashMap<EState, EState>();
        map.put((EState)this.entry, res);
        map.put((EState)this.exit, resTerm);
        HashSet<EState> seen = new HashSet<EState>();
        this.fixContinueEdges(seen, map, (EState)this.entry, res);
        if (!seen.contains(this.exit)) {
            resTerm = null;
        }
        return new EGraph(res, resTerm);
    }

    private void fixContinueEdges(Set<EState> seen, Map<EState, EState> map, EState curr, EState res) {
        if (seen.contains(curr)) {
            return;
        }
        seen.add(curr);
        Iterator as = curr.getAllActions().iterator();
        Iterator ss = curr.getAllSuccessors().iterator();
        while (as.hasNext()) {
            EAction a = (EAction)as.next();
            EState succ = (EState)ss.next();
            EState next = this.getNext(map, succ);
            if (!(a instanceof IntermediateContinueEdge)) {
                this.addEdgeAux(res, a, next);
                this.fixContinueEdges(seen, map, succ, next);
                continue;
            }
            IntermediateContinueEdge ice = (IntermediateContinueEdge)a;
            RecVar rv = new RecVar(ice.mid.toString());
            for (EAction e : this.enactingMap.get(succ).get(rv)) {
                for (EState n : succ.getSuccessors(e)) {
                    next = this.getNext(map, n);
                    this.addEdgeAux(res, e, next);
                    this.fixContinueEdges(seen, map, succ, next);
                }
            }
        }
    }

    private EState getNext(Map<EState, EState> map, EState succ) {
        EState next;
        if (map.containsKey(succ)) {
            next = map.get(succ);
        } else {
            next = new EState(succ.getLabels());
            map.put(succ, next);
        }
        return next;
    }
}

