/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.endpoint;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.scribble.main.ScribbleException;
import org.scribble.model.MPrettyState;
import org.scribble.model.MState;
import org.scribble.model.endpoint.EGraph;
import org.scribble.model.endpoint.EStateKind;
import org.scribble.model.endpoint.actions.EAction;
import org.scribble.sesstype.kind.Local;
import org.scribble.sesstype.name.RecVar;

public class EState
extends MPrettyState<RecVar, EAction, EState, Local> {
    protected EState(Set<RecVar> labs) {
        super(labs);
    }

    public EGraph toGraph() {
        return new EGraph(this, EState.getTerminal(this));
    }

    public EState unfairTransform() {
        EState init = this.clone();
        EState term = MPrettyState.getTerminal(init);
        HashSet<EState> seen = new HashSet<EState>();
        LinkedHashSet<EState> todo = new LinkedHashSet<EState>();
        todo.add(init);
        while (!todo.isEmpty()) {
            Iterator i = todo.iterator();
            EState curr = (EState)i.next();
            i.remove();
            if (seen.contains(curr)) continue;
            seen.add(curr);
            if (curr.getStateKind() == EStateKind.OUTPUT && curr.getAllActions().size() > 1) {
                Iterator as = curr.getAllActions().iterator();
                Iterator ss = curr.getAllSuccessors().iterator();
                LinkedList<Object> cloneas = new LinkedList<Object>();
                LinkedList<Object> cloness = new LinkedList<Object>();
                HashMap<EState, LinkedList<Object>> toRemove = new HashMap<EState, LinkedList<Object>>();
                while (as.hasNext()) {
                    EAction a = (EAction)as.next();
                    EState s = (EState)ss.next();
                    if (!s.canReach(curr)) {
                        todo.add(s);
                        continue;
                    }
                    EState clone = curr.unfairClone(term, a, s);
                    cloneas.add(a);
                    cloness.add(clone);
                    LinkedList<Object> tmp = (List)toRemove.get(s);
                    if (tmp == null) {
                        tmp = new LinkedList<Object>();
                        toRemove.put(s, tmp);
                    }
                    tmp.add(a);
                }
                if (cloneas.isEmpty()) continue;
                for (EState s : toRemove.keySet()) {
                    try {
                        for (LinkedList<Object> tmp : (List)toRemove.get(s)) {
                            curr.removeEdge(tmp, s);
                        }
                    }
                    catch (ScribbleException e) {
                        throw new RuntimeException(e);
                    }
                }
                Iterator icloneas = cloneas.iterator();
                Iterator icloness = cloness.iterator();
                while (icloneas.hasNext()) {
                    EAction a = (EAction)icloneas.next();
                    EState s = (EState)icloness.next();
                    curr.addEdge(a, s);
                    todo.add(s);
                }
                continue;
            }
            todo.addAll(curr.getAllSuccessors());
        }
        return init;
    }

    protected EState clone() {
        HashSet<EState> all = new HashSet<EState>();
        all.add(this);
        all.addAll(MPrettyState.getReachableStates(this));
        HashMap<Integer, EState> map = new HashMap<Integer, EState>();
        for (EState s : all) {
            map.put(s.id, new EState(s.labs));
        }
        for (EState s : all) {
            Iterator as = s.getAllActions().iterator();
            Iterator ss = s.getAllSuccessors().iterator();
            EState clone = (EState)map.get(s.id);
            while (as.hasNext()) {
                EAction a = (EAction)as.next();
                EState succ = (EState)ss.next();
                clone.addEdge(a, (MState)map.get(succ.id));
            }
        }
        return (EState)map.get(this.id);
    }

    protected EState unfairClone(EState term, EAction a, EState succ) {
        HashSet<EState> all = new HashSet<EState>();
        all.add(succ);
        all.addAll(MPrettyState.getReachableStates(succ));
        HashMap<Integer, EState> map = new HashMap<Integer, EState>();
        for (EState s : all) {
            if (term != null && s.id == term.id) {
                map.put(term.id, term);
                continue;
            }
            map.put(s.id, new EState(Collections.emptySet()));
        }
        for (EState s : all) {
            Iterator as = s.getAllActions().iterator();
            Iterator ss = s.getAllSuccessors().iterator();
            EState clone = (EState)map.get(s.id);
            while (as.hasNext()) {
                EAction tmpa = (EAction)as.next();
                EState tmps = (EState)ss.next();
                if (s.id == this.id && (!tmpa.equals(a) || !tmps.equals(succ))) continue;
                clone.addEdge(tmpa, (MState)map.get(tmps.id));
            }
        }
        return (EState)map.get(succ.id);
    }

    public boolean isConnectOrWrapClientOnly() {
        return this.getStateKind() == EStateKind.OUTPUT && this.getAllActions().stream().allMatch(a -> a.isConnect() || a.isWrapClient());
    }

    public EStateKind getStateKind() {
        List as = this.getAllActions();
        if (as.size() == 0) {
            return EStateKind.TERMINAL;
        }
        if (as.stream().allMatch(a -> a.isSend() || a.isConnect() || a.isWrapClient())) {
            return EStateKind.OUTPUT;
        }
        if (as.stream().allMatch(a -> a.isReceive())) {
            return as.size() == 1 ? EStateKind.UNARY_INPUT : EStateKind.POLY_INPUT;
        }
        if (as.stream().allMatch(a -> a.isAccept())) {
            return EStateKind.ACCEPT;
        }
        if (as.size() == 1 && ((EAction)as.iterator().next()).isDisconnect()) {
            return EStateKind.OUTPUT;
        }
        if (as.size() == 1 && ((EAction)as.iterator().next()).isWrapServer()) {
            return EStateKind.WRAP_SERVER;
        }
        throw new RuntimeException("Shouldn't get in here: " + as);
    }

    @Override
    public int hashCode() {
        int hash = 83;
        hash = 31 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EState)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEquals(MState<?, ?, ?, ?> s) {
        return s instanceof EState;
    }
}

