/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.global;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.model.endpoint.EState;
import org.scribble.model.endpoint.actions.EAccept;
import org.scribble.model.endpoint.actions.EAction;
import org.scribble.model.endpoint.actions.EConnect;
import org.scribble.model.endpoint.actions.EDisconnect;
import org.scribble.model.endpoint.actions.EReceive;
import org.scribble.model.endpoint.actions.ESend;
import org.scribble.model.endpoint.actions.EWrapClient;
import org.scribble.model.endpoint.actions.EWrapServer;
import org.scribble.sesstype.name.Role;

public class SBuffers {
    private final Map<Role, Map<Role, Boolean>> connected = new HashMap<Role, Map<Role, Boolean>>();
    private final Map<Role, Map<Role, ESend>> buffs = new HashMap<Role, Map<Role, ESend>>();

    public SBuffers(Set<Role> roles, boolean implicit) {
        this(roles);
        if (implicit) {
            roles.forEach(k -> {
                HashMap tmp = new HashMap();
                this.connected.put((Role)k, tmp);
                roles.forEach(k2 -> {
                    if (!k.equals(k2)) {
                        tmp.put(k2, true);
                    }
                });
            });
        }
    }

    public SBuffers(Set<Role> roles) {
        roles.forEach(k -> {
            HashMap tmp = new HashMap();
            this.buffs.put((Role)k, tmp);
            roles.forEach(k2 -> {
                if (!k.equals(k2)) {
                    tmp.put(k2, null);
                }
            });
        });
    }

    public SBuffers(SBuffers buffs) {
        Set<Role> roles = buffs.buffs.keySet();
        roles.forEach(k -> {
            Map<Role, Boolean> tmp = buffs.connected.get(k);
            if (tmp != null) {
                this.connected.put((Role)k, (Map<Role, Boolean>)new HashMap<Role, Boolean>(tmp));
            }
        });
        roles.forEach(k -> this.buffs.put((Role)k, (Map<Role, ESend>)new HashMap<Role, ESend>(buffs.buffs.get(k))));
    }

    public Map<Role, Map<Role, ESend>> getBuffers() {
        return new SBuffers((SBuffers)this).buffs;
    }

    public Map<Role, ESend> get(Role r) {
        return Collections.unmodifiableMap(this.buffs.get(r));
    }

    public boolean isEmpty(Role r) {
        return this.buffs.get(r).values().stream().allMatch(v -> v == null);
    }

    public boolean isConnected(Role self, Role peer) {
        Map<Role, Boolean> tmp = this.connected.get(self);
        if (tmp == null) {
            return false;
        }
        Boolean b = tmp.get(peer);
        return b != null && b != false;
    }

    public boolean canAccept(Role self, EAccept a) {
        return !this.isConnected(self, a.peer);
    }

    public boolean canConnect(Role self, EConnect c) {
        return !this.isConnected(self, c.peer);
    }

    public boolean canDisconnect(Role self, EDisconnect d) {
        return this.isConnected(self, d.peer);
    }

    public boolean canWrapClient(Role self, EWrapClient wc) {
        return this.isConnected(self, wc.peer);
    }

    public boolean canWrapServer(Role self, EWrapServer ws) {
        return this.isConnected(self, ws.peer);
    }

    public SBuffers connect(Role src, Role dest) {
        SBuffers copy = new SBuffers(this);
        Map<Role, Boolean> tmp1 = copy.connected.get(src);
        if (tmp1 == null) {
            tmp1 = new HashMap<Role, Boolean>();
            copy.connected.put(src, tmp1);
        }
        tmp1.put(dest, true);
        Map<Role, Boolean> tmp2 = copy.connected.get(dest);
        if (tmp2 == null) {
            tmp2 = new HashMap<Role, Boolean>();
            copy.connected.put(dest, tmp2);
        }
        tmp2.put(src, true);
        return copy;
    }

    public SBuffers disconnect(Role self, EDisconnect d) {
        SBuffers copy = new SBuffers(this);
        copy.connected.get(self).put(d.peer, false);
        return copy;
    }

    public boolean canSend(Role self, ESend a) {
        return this.isConnected(self, a.peer) && this.buffs.get(a.peer).get(self) == null;
    }

    public SBuffers send(Role self, ESend a) {
        SBuffers copy = new SBuffers(this);
        copy.buffs.get(a.peer).put(self, a);
        return copy;
    }

    public Set<EAction> inputable(Role r) {
        Set<EAction> res = this.buffs.get(r).entrySet().stream().filter(e -> e.getValue() != null).map(e -> ((ESend)e.getValue()).toDual((Role)e.getKey())).collect(Collectors.toSet());
        return res;
    }

    public Set<EAction> acceptable(Role r, EState curr) {
        Boolean b;
        HashSet<EAction> res = new HashSet<EAction>();
        Map<Role, Boolean> tmp = this.connected.get(r);
        if (tmp != null && (b = tmp.get(r)) != null && b.booleanValue()) {
            return res;
        }
        List as = curr.getAllActions();
        for (EAction a : as) {
            res.add((EAccept)a);
        }
        return res;
    }

    public Set<EAction> wrapable(Role r) {
        HashSet<EAction> res = new HashSet<EAction>();
        Map<Role, Boolean> tmp = this.connected.get(r);
        if (tmp != null) {
            this.connected.keySet().stream().filter(k -> tmp.containsKey(k) && (Boolean)tmp.get(k) != false).forEach(k -> res.add(new EWrapServer((Role)k)));
        }
        return res;
    }

    public SBuffers receive(Role self, EReceive a) {
        SBuffers copy = new SBuffers(this);
        copy.buffs.get(self).put(a.peer, null);
        return copy;
    }

    public final int hashCode() {
        int hash = 131;
        hash = 31 * hash + this.buffs.hashCode();
        hash = 31 * hash + this.connected.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SBuffers)) {
            return false;
        }
        SBuffers b = (SBuffers)o;
        return this.buffs.equals(b.buffs) && this.connected.equals(b.connected);
    }

    public String toString() {
        return this.buffs.entrySet().stream().filter(e -> ((Map)e.getValue()).values().stream().anyMatch(v -> v != null)).collect(Collectors.toMap(e -> (Role)e.getKey(), e -> ((Map)e.getValue()).entrySet().stream().filter(f -> f.getValue() != null).collect(Collectors.toMap(f -> (Role)f.getKey(), f -> (ESend)f.getValue())))).toString();
    }
}

