/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.global;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.model.endpoint.EFSM;
import org.scribble.model.endpoint.EState;
import org.scribble.model.endpoint.EStateKind;
import org.scribble.model.endpoint.actions.EAccept;
import org.scribble.model.endpoint.actions.EAction;
import org.scribble.model.endpoint.actions.EConnect;
import org.scribble.model.endpoint.actions.EDisconnect;
import org.scribble.model.endpoint.actions.EReceive;
import org.scribble.model.endpoint.actions.ESend;
import org.scribble.model.endpoint.actions.EWrapClient;
import org.scribble.model.endpoint.actions.EWrapServer;
import org.scribble.model.global.SBuffers;
import org.scribble.sesstype.name.Role;

public class SConfig {
    public final Map<Role, EFSM> efsms;
    public final SBuffers buffs;

    public SConfig(Map<Role, EFSM> state, SBuffers buffs) {
        this.efsms = Collections.unmodifiableMap(state);
        this.buffs = buffs;
    }

    public boolean isSafeTermination() {
        for (Role r : this.efsms.keySet()) {
            if (this.canSafelyTerminate(r)) continue;
            return false;
        }
        return true;
    }

    public boolean canSafelyTerminate(Role r) {
        EFSM s = this.efsms.get(r);
        boolean canSafelyTerminate = s.isTerminated() && this.buffs.isEmpty(r) || s.getStateKind().equals((Object)EStateKind.ACCEPT) && s.isInitial();
        return canSafelyTerminate;
    }

    public List<SConfig> fire(Role r, EAction a) {
        LinkedList<SConfig> res = new LinkedList<SConfig>();
        List<EFSM> succs = this.efsms.get(r).fireAll(a);
        for (EFSM succ : succs) {
            SBuffers tmp2;
            HashMap<Role, EFSM> tmp1 = new HashMap<Role, EFSM>(this.efsms);
            tmp1.put(r, succ);
            SBuffers sBuffers = a.isSend() ? this.buffs.send(r, (ESend)a) : (a.isReceive() ? this.buffs.receive(r, (EReceive)a) : (tmp2 = a.isDisconnect() ? this.buffs.disconnect(r, (EDisconnect)a) : null));
            if (tmp2 == null) {
                throw new RuntimeException("Shouldn't get in here: " + a);
            }
            res.add(new SConfig(tmp1, tmp2));
        }
        return res;
    }

    public List<SConfig> sync(Role r1, EAction a1, Role r2, EAction a2) {
        LinkedList<SConfig> res = new LinkedList<SConfig>();
        List<EFSM> succs1 = this.efsms.get(r1).fireAll(a1);
        List<EFSM> succs2 = this.efsms.get(r2).fireAll(a2);
        for (EFSM succ1 : succs1) {
            for (EFSM succ2 : succs2) {
                SBuffers tmp2;
                HashMap<Role, EFSM> tmp1 = new HashMap<Role, EFSM>(this.efsms);
                tmp1.put(r1, succ1);
                tmp1.put(r2, succ2);
                if (a1.isConnect() && a2.isAccept() || a1.isAccept() && a2.isConnect()) {
                    tmp2 = this.buffs.connect(r1, r2);
                } else if (a1.isWrapClient() && a2.isWrapServer() || a1.isWrapServer() && a2.isWrapClient()) {
                    tmp2 = this.buffs;
                } else {
                    throw new RuntimeException("Shouldn't get in here: " + a1 + ", " + a2);
                }
                res.add(new SConfig(tmp1, tmp2));
            }
        }
        return res;
    }

    public Map<Role, EReceive> getStuckMessages() {
        HashMap<Role, EReceive> res = new HashMap<Role, EReceive>();
        for (Role r : this.efsms.keySet()) {
            EReceive recv;
            EFSM s = this.efsms.get(r);
            EStateKind k = s.getStateKind();
            if (k != EStateKind.UNARY_INPUT && k != EStateKind.POLY_INPUT) continue;
            Role peer = s.getAllFireable().iterator().next().peer;
            ESend send = this.buffs.get(r).get(peer);
            if (send == null || s.hasFireable(recv = send.toDual(peer))) continue;
            res.put(r, recv);
        }
        return res;
    }

    public Set<Set<Role>> getWaitForErrors() {
        HashSet<Set<Role>> res = new HashSet<Set<Role>>();
        LinkedList<Role> todo = new LinkedList<Role>(this.efsms.keySet());
        while (!todo.isEmpty()) {
            Set<Role> cycle;
            Role r = (Role)todo.remove(0);
            if (this.efsms.get(r).isTerminated() || (cycle = this.isWaitForChain(r)) == null) continue;
            todo.removeAll(cycle);
            res.add(cycle);
        }
        return res;
    }

    public Set<Role> isWaitForChain(Role orig) {
        LinkedHashSet<Role> candidate = new LinkedHashSet<Role>();
        LinkedHashSet<Role> todo = new LinkedHashSet<Role>(Arrays.asList(orig));
        while (!todo.isEmpty()) {
            Role r = (Role)todo.iterator().next();
            todo.remove(r);
            candidate.add(r);
            EFSM s = this.efsms.get(r);
            if (s == null) {
                System.out.println("AAA: " + this.efsms + ", " + r);
            }
            if (s.getStateKind() == EStateKind.OUTPUT && !s.isConnectOrWrapClientOnly()) {
                return null;
            }
            if (s.isTerminated()) {
                if (!todo.isEmpty()) continue;
                return candidate;
            }
            Set<Role> blocked = this.isWaitingFor(r);
            if (blocked == null) {
                return null;
            }
            if (todo.isEmpty() && candidate.containsAll(blocked)) {
                return candidate;
            }
            blocked.forEach(x -> {
                if (!candidate.contains(x)) {
                    todo.add((Role)x);
                }
            });
        }
        return null;
    }

    private Set<Role> isWaitingFor(Role r) {
        EFSM s = this.efsms.get(r);
        EStateKind k = s.getStateKind();
        if (k == EStateKind.UNARY_INPUT || k == EStateKind.POLY_INPUT) {
            Set<Role> peers;
            List<EAction> all = s.getAllFireable();
            EAction a = all.get(0);
            if (a.isReceive() && (peers = all.stream().map(x -> x.peer).collect(Collectors.toSet())).stream().noneMatch(p -> this.buffs.get(r).get(p) != null)) {
                return peers;
            }
        } else if (k == EStateKind.ACCEPT) {
            if (!s.isInitial()) {
                List<EAction> all = s.getAllFireable();
                HashSet<Role> res = new HashSet<Role>();
                for (EAction a : all) {
                    if (this.efsms.get(a.peer).getAllFireable().contains(a.toDual(r))) {
                        return null;
                    }
                    res.add(a.peer);
                }
                if (!res.isEmpty()) {
                    return res;
                }
            }
        } else if (k == EStateKind.OUTPUT && s.isConnectOrWrapClientOnly()) {
            List<EAction> all = s.getAllFireable();
            HashSet<Role> res = new HashSet<Role>();
            for (EAction a : all) {
                if (this.efsms.get(a.peer).getAllFireable().contains(a.toDual(r))) {
                    return null;
                }
                res.add(a.peer);
            }
            if (!res.isEmpty()) {
                return res;
            }
        }
        return null;
    }

    public Map<Role, Set<ESend>> getOrphanMessages() {
        HashMap<Role, Set<ESend>> res = new HashMap<Role, Set<ESend>>();
        for (Role r : this.efsms.keySet()) {
            EFSM s = this.efsms.get(r);
            if (s.isTerminated()) {
                Set orphs = this.buffs.get(r).values().stream().filter(v -> v != null).collect(Collectors.toSet());
                if (orphs.isEmpty()) continue;
                HashSet tmp = (HashSet)res.get(r);
                if (tmp == null) {
                    tmp = new HashSet();
                    res.put(r, tmp);
                }
                tmp.addAll(orphs);
                continue;
            }
            this.efsms.keySet().forEach(rr -> {
                ESend send;
                if (!rr.equals(r) && !this.buffs.isConnected(r, (Role)rr) && (send = this.buffs.get(r).get(rr)) != null) {
                    HashSet<ESend> tmp = (HashSet<ESend>)res.get(r);
                    if (tmp == null) {
                        tmp = new HashSet<ESend>();
                        res.put(r, tmp);
                    }
                    tmp.add(send);
                }
            });
        }
        return res;
    }

    public Map<Role, EState> getUnfinishedRoles() {
        HashMap<Role, EState> res = new HashMap<Role, EState>();
        if (this.getFireable().isEmpty() && !this.isSafeTermination()) {
            for (Role r : this.efsms.keySet()) {
                if (this.canSafelyTerminate(r)) continue;
                res.put(r, this.efsms.get((Object)r).curr);
            }
        }
        return res;
    }

    public Map<Role, List<EAction>> getFireable() {
        HashMap<Role, List<EAction>> res = new HashMap<Role, List<EAction>>();
        block7: for (Role r : this.efsms.keySet()) {
            EFSM fsm = this.efsms.get(r);
            switch (fsm.getStateKind()) {
                case OUTPUT: {
                    List<EAction> as = fsm.getAllFireable();
                    for (EAction a : as) {
                        List<EAction> tmp;
                        List<EAction> peeras;
                        EFSM speer;
                        List<EAction> tmp2;
                        if (a.isSend()) {
                            if (!this.buffs.canSend(r, (ESend)a)) continue;
                            tmp2 = (LinkedList<EAction>)res.get(r);
                            if (tmp2 == null) {
                                tmp2 = new LinkedList<EAction>();
                                res.put(r, tmp2);
                            }
                            tmp2.add(a);
                            continue;
                        }
                        if (a.isConnect()) {
                            EConnect c = (EConnect)a;
                            speer = this.efsms.get(c.peer);
                            peeras = speer.getAllFireable();
                            for (EAction peera : peeras) {
                                if (!peera.equals(c.toDual(r)) || !this.buffs.canConnect(r, c)) continue;
                                tmp = (LinkedList<EAction>)res.get(r);
                                if (tmp == null) {
                                    tmp = new LinkedList<EAction>();
                                    res.put(r, tmp);
                                }
                                tmp.add(a);
                            }
                            continue;
                        }
                        if (a.isDisconnect()) {
                            if (!this.buffs.canDisconnect(r, (EDisconnect)a)) continue;
                            tmp2 = (List)res.get(r);
                            if (tmp2 == null) {
                                tmp2 = new LinkedList();
                                res.put(r, tmp2);
                            }
                            tmp2.add(a);
                            continue;
                        }
                        if (a.isWrapClient()) {
                            EWrapClient wc = (EWrapClient)a;
                            speer = this.efsms.get(wc.peer);
                            peeras = speer.getAllFireable();
                            for (EAction peera : peeras) {
                                if (!peera.equals(wc.toDual(r)) || !this.buffs.canWrapClient(r, wc)) continue;
                                tmp = (List)res.get(r);
                                if (tmp == null) {
                                    tmp = new LinkedList();
                                    res.put(r, tmp);
                                }
                                tmp.add(a);
                            }
                            continue;
                        }
                        throw new RuntimeException("Shouldn't get in here: " + a);
                    }
                    continue block7;
                }
                case UNARY_INPUT: 
                case POLY_INPUT: {
                    for (EAction a : this.buffs.inputable(r)) {
                        if (a.isReceive()) {
                            if (!fsm.hasFireable(a)) continue;
                            LinkedList<EAction> tmp = (LinkedList<EAction>)res.get(r);
                            if (tmp == null) {
                                tmp = new LinkedList<EAction>();
                                res.put(r, tmp);
                            }
                            tmp.add(a);
                            continue;
                        }
                        throw new RuntimeException("Shouldn't get in here: " + a);
                    }
                    continue block7;
                }
                case TERMINAL: {
                    break;
                }
                case ACCEPT: {
                    List<EAction> tmp;
                    List<EAction> peeras;
                    EFSM speer;
                    for (EAction a : this.buffs.acceptable(r, fsm.curr)) {
                        if (a.isAccept()) {
                            EAccept c = (EAccept)a;
                            speer = this.efsms.get(c.peer);
                            peeras = speer.getAllFireable();
                            for (EAction peera : peeras) {
                                if (!peera.equals(c.toDual(r)) || !this.buffs.canAccept(r, c)) continue;
                                tmp = (List)res.get(r);
                                if (tmp == null) {
                                    tmp = new LinkedList();
                                    res.put(r, tmp);
                                }
                                tmp.add(a);
                            }
                            continue;
                        }
                        throw new RuntimeException("Shouldn't get in here: " + a);
                    }
                    continue block7;
                }
                case WRAP_SERVER: {
                    List<EAction> tmp;
                    List<EAction> peeras;
                    EFSM speer;
                    for (EAction a : this.buffs.wrapable(r)) {
                        if (a.isWrapServer()) {
                            EWrapServer ws = (EWrapServer)a;
                            speer = this.efsms.get(ws.peer);
                            peeras = speer.getAllFireable();
                            for (EAction peera : peeras) {
                                if (!peera.equals(ws.toDual(r)) || !this.buffs.canWrapServer(r, ws)) continue;
                                tmp = (LinkedList<EAction>)res.get(r);
                                if (tmp == null) {
                                    tmp = new LinkedList<EAction>();
                                    res.put(r, tmp);
                                }
                                tmp.add(a);
                            }
                            continue;
                        }
                        throw new RuntimeException("Shouldn't get in here: " + a);
                    }
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Shouldn't get in here: " + fsm);
                }
            }
        }
        return res;
    }

    public final int hashCode() {
        int hash = 71;
        hash = 31 * hash + this.efsms.hashCode();
        hash = 31 * hash + this.buffs.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SConfig)) {
            return false;
        }
        SConfig c = (SConfig)o;
        return this.efsms.equals(c.efsms) && this.buffs.equals(c.buffs);
    }

    public String toString() {
        return "(" + this.efsms + ", " + this.buffs + ")";
    }
}

