/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.global;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.scribble.main.Job;
import org.scribble.main.ScribbleException;
import org.scribble.model.MPrettyPrint;
import org.scribble.model.endpoint.EFSM;
import org.scribble.model.endpoint.EGraph;
import org.scribble.model.endpoint.EStateKind;
import org.scribble.model.endpoint.actions.EAction;
import org.scribble.model.global.SBuffers;
import org.scribble.model.global.SConfig;
import org.scribble.model.global.SModel;
import org.scribble.model.global.SState;
import org.scribble.model.global.actions.SAction;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.Role;

public class SGraph
implements MPrettyPrint {
    public final GProtocolName proto;
    public final SState init;
    public Map<Integer, SState> states;
    private Map<Integer, Set<Integer>> reach;
    private Set<Set<Integer>> termSets;

    protected SGraph(GProtocolName proto, Map<Integer, SState> states, SState init) {
        this.proto = proto;
        this.init = init;
        this.states = Collections.unmodifiableMap(states);
        this.reach = this.getReachabilityMap();
    }

    public SModel toModel() {
        return new SModel(this);
    }

    public Set<Set<Integer>> getTerminalSets() {
        if (this.termSets != null) {
            return this.termSets;
        }
        HashSet<Set<Integer>> termSets = new HashSet<Set<Integer>>();
        HashSet<Set<Integer>> checked = new HashSet<Set<Integer>>();
        for (Integer i : this.reach.keySet()) {
            SState s = this.states.get(i);
            Set<Integer> rs = this.reach.get(s.id);
            if (checked.contains(rs) || !rs.contains(s.id)) continue;
            checked.add(rs);
            if (!this.isTerminalSetMember(s)) continue;
            termSets.add(rs);
        }
        this.termSets = Collections.unmodifiableSet(termSets);
        return this.termSets;
    }

    private boolean isTerminalSetMember(SState s) {
        Set<Integer> rs = this.reach.get(s.id);
        HashSet<Integer> tmp = new HashSet<Integer>(rs);
        tmp.remove(s.id);
        for (Integer r : tmp) {
            if (this.reach.containsKey(r) && this.reach.get(r).equals(rs)) continue;
            return false;
        }
        return true;
    }

    public List<SAction> getTrace(SState start, SState end) {
        TreeMap<Integer, Set<Integer>> candidates = new TreeMap<Integer, Set<Integer>>();
        HashSet<Integer> dis0 = new HashSet<Integer>();
        dis0.add(start.id);
        candidates.put(0, dis0);
        HashSet<Integer> seen = new HashSet<Integer>();
        seen.add(start.id);
        return this.getTraceAux(new LinkedList<SAction>(), seen, candidates, end);
    }

    private List<SAction> getTraceAux(List<SAction> trace, Set<Integer> seen, SortedMap<Integer, Set<Integer>> candidates, SState end) {
        Integer dis = candidates.keySet().iterator().next();
        Set cs = (Set)candidates.get(dis);
        Iterator it = cs.iterator();
        Integer currid = (Integer)it.next();
        it.remove();
        if (cs.isEmpty()) {
            candidates.remove(dis);
        }
        SState curr = this.states.get(currid);
        Iterator as = curr.getAllActions().iterator();
        Iterator ss = curr.getAllSuccessors().iterator();
        while (as.hasNext()) {
            SAction a = (SAction)as.next();
            SState s = (SState)ss.next();
            if (s.id == end.id) {
                trace.add(a);
                return trace;
            }
            if (seen.contains(s.id) || !this.reach.containsKey(s.id) || !this.reach.get(s.id).contains(end.id)) continue;
            seen.add(s.id);
            HashSet<Integer> tmp1 = (HashSet<Integer>)candidates.get(dis + 1);
            if (tmp1 == null) {
                tmp1 = new HashSet<Integer>();
                candidates.put(dis + 1, tmp1);
            }
            tmp1.add(s.id);
            LinkedList<SAction> tmp2 = new LinkedList<SAction>(trace);
            tmp2.add(a);
            List<SAction> res = this.getTraceAux(tmp2, seen, candidates, end);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public Map<Integer, Set<Integer>> getReachabilityMap() {
        if (this.reach != null) {
            return this.reach;
        }
        HashMap<Integer, Integer> idToIndex = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> indexToId = new HashMap<Integer, Integer>();
        int i = 0;
        for (SState s : this.states.values()) {
            idToIndex.put(s.id, i);
            indexToId.put(i, s.id);
            ++i;
        }
        this.reach = this.getReachabilityAux(idToIndex, indexToId);
        return this.reach;
    }

    private Map<Integer, Set<Integer>> getReachabilityAux(Map<Integer, Integer> idToIndex, Map<Integer, Integer> indexToId) {
        int size = idToIndex.keySet().size();
        boolean[][] reach = new boolean[size][size];
        for (Integer s1id : idToIndex.keySet()) {
            for (SState s2 : this.states.get(s1id).getAllSuccessors()) {
                reach[idToIndex.get((Object)s1id).intValue()][idToIndex.get((Object)Integer.valueOf((int)s2.id)).intValue()] = true;
            }
        }
        boolean again = true;
        while (again) {
            again = false;
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    if (!reach[i][j]) continue;
                    for (int k = 0; k < size; ++k) {
                        if (!reach[j][k] || reach[i][k]) continue;
                        reach[i][k] = true;
                        again = true;
                    }
                }
            }
        }
        HashMap<Integer, HashSet<Integer>> res = new HashMap<Integer, HashSet<Integer>>();
        for (int i = 0; i < size; ++i) {
            HashSet<Integer> tmp = (HashSet<Integer>)res.get(indexToId.get(i));
            for (int j = 0; j < size; ++j) {
                if (!reach[i][j]) continue;
                if (tmp == null) {
                    tmp = new HashSet<Integer>();
                    res.put(indexToId.get(i), tmp);
                }
                tmp.add(indexToId.get(j));
            }
        }
        return Collections.unmodifiableMap(res);
    }

    @Override
    public String toDot() {
        return this.init.toDot();
    }

    @Override
    public String toAut() {
        return this.init.toAut();
    }

    public String toString() {
        return this.init.toString();
    }

    public static SGraph buildSGraph(Map<Role, EGraph> egraphs, boolean explicit, Job job, GProtocolName fullname) throws ScribbleException {
        for (Role r : egraphs.keySet()) {
            job.debugPrintln("(" + fullname + ") Building global model using EFSM for " + r + ":\n" + egraphs.get((Object)r).init.toDot());
        }
        Map<Role, EFSM> efsms = egraphs.entrySet().stream().collect(Collectors.toMap(e -> (Role)e.getKey(), e -> ((EGraph)e.getValue()).toFsm()));
        SBuffers b0 = new SBuffers(efsms.keySet(), !explicit);
        SConfig c0 = new SConfig(efsms, b0);
        SState init = new SState(c0);
        HashMap<Integer, SState> seen = new HashMap<Integer, SState>();
        LinkedHashSet<SState> todo = new LinkedHashSet<SState>();
        todo.add(init);
        int count = 0;
        while (!todo.isEmpty()) {
            List<EAction> fireable_r;
            Iterator i = todo.iterator();
            SState curr = (SState)i.next();
            i.remove();
            seen.put(curr.id, curr);
            if (job.debug && ++count % 50 == 0) {
                job.debugPrintln("(" + fullname + ") Building global states: " + count);
            }
            Map<Role, List<EAction>> fireable = curr.getFireable();
            for (Role r : fireable.keySet()) {
                fireable_r = fireable.get(r);
                EFSM currfsm = curr.config.efsms.get(r);
                EStateKind k = currfsm.getStateKind();
                if (k == EStateKind.OUTPUT) {
                    for (EAction a : fireable_r) {
                        if (!fireable_r.stream().anyMatch(x -> !a.equals(x) && a.peer.equals(x.peer) && a.mid.equals(x.mid) && !a.payload.equals(x.payload))) continue;
                        throw new ScribbleException("Bad non-deterministic action payloads: " + fireable_r);
                    }
                    continue;
                }
                if (k != EStateKind.UNARY_INPUT && k != EStateKind.POLY_INPUT && k != EStateKind.ACCEPT) continue;
                for (EAction a : fireable_r) {
                    if (!currfsm.getAllFireable().stream().anyMatch(x -> !a.equals(x) && a.peer.equals(x.peer) && a.mid.equals(x.mid) && !a.payload.equals(x.payload))) continue;
                    throw new ScribbleException("Bad non-deterministic action payloads: " + currfsm.getAllFireable());
                }
            }
            for (Role r : fireable.keySet()) {
                fireable_r = fireable.get(r);
                for (EAction a : fireable_r) {
                    SAction g;
                    List<EAction> as;
                    if (a.isSend() || a.isReceive() || a.isDisconnect()) {
                        SGraph.getNextStates(todo, seen, curr, a.toGlobal(r), curr.fire(r, a));
                        continue;
                    }
                    if (a.isAccept() || a.isConnect()) {
                        as = fireable.get(a.peer);
                        EAction d = a.toDual(r);
                        if (as == null || !as.contains(d)) continue;
                        as.remove(d);
                        g = a.isConnect() ? a.toGlobal(r) : d.toGlobal(a.peer);
                        SGraph.getNextStates(todo, seen, curr, g, curr.sync(r, a, a.peer, d));
                        continue;
                    }
                    if (a.isWrapClient() || a.isWrapServer()) {
                        as = fireable.get(a.peer);
                        EAction w = a.toDual(r);
                        if (as == null || !as.contains(w)) continue;
                        as.remove(w);
                        g = a.isConnect() ? a.toGlobal(r) : w.toGlobal(a.peer);
                        SGraph.getNextStates(todo, seen, curr, g, curr.sync(r, a, a.peer, w));
                        continue;
                    }
                    throw new RuntimeException("Shouldn't get in here: " + a);
                }
            }
        }
        SGraph graph = new SGraph(fullname, seen, init);
        job.debugPrintln("(" + fullname + ") Built global model..\n" + graph.init.toDot() + "\n(" + fullname + ") .." + graph.states.size() + " states");
        return graph;
    }

    private static void getNextStates(LinkedHashSet<SState> todo, Map<Integer, SState> seen, SState curr, SAction a, List<SConfig> nexts) {
        for (SConfig next : nexts) {
            SState news = new SState(next);
            SState succ = null;
            for (SState tmp : seen.values()) {
                if (!tmp.equals(news)) continue;
                succ = tmp;
            }
            if (succ == null) {
                for (SState tmp : todo) {
                    if (!tmp.equals(news)) continue;
                    succ = tmp;
                }
            }
            if (succ == null) {
                succ = news;
                todo.add(succ);
            }
            curr.addEdge(a, succ);
        }
    }
}

