/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.global;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.main.Job;
import org.scribble.main.ScribbleException;
import org.scribble.model.endpoint.EFSM;
import org.scribble.model.endpoint.actions.ESend;
import org.scribble.model.global.SBuffers;
import org.scribble.model.global.SGraph;
import org.scribble.model.global.SState;
import org.scribble.model.global.SStateErrors;
import org.scribble.model.global.actions.SAction;
import org.scribble.sesstype.name.Role;

public class SModel {
    public final SGraph graph;

    protected SModel(SGraph graph) {
        this.graph = graph;
    }

    public void validate(Job job) throws ScribbleException {
        SState init = this.graph.init;
        Map<Integer, SState> states = this.graph.states;
        String errorMsg = "";
        int count = 0;
        for (SState s : states.values()) {
            SStateErrors errors;
            if (job.debug && ++count % 50 == 0) {
                job.debugPrintln("(" + this.graph.proto + ") Checking states: " + count);
            }
            if (!(errors = s.getErrors()).isEmpty()) {
                List<SAction> trace = this.graph.getTrace(init, s);
                errorMsg = errorMsg + "\nSafety violation(s) at session state " + s.id + ":\n    Trace=" + trace;
            }
            if (!errors.stuck.isEmpty()) {
                errorMsg = errorMsg + "\n    Stuck messages: " + errors.stuck;
            }
            if (!errors.waitFor.isEmpty()) {
                errorMsg = errorMsg + "\n    Wait-for errors: " + errors.waitFor;
            }
            if (!errors.orphans.isEmpty()) {
                errorMsg = errorMsg + "\n    Orphan messages: " + errors.orphans;
            }
            if (errors.unfinished.isEmpty()) continue;
            errorMsg = errorMsg + "\n    Unfinished roles: " + errors.unfinished;
        }
        job.debugPrintln("(" + this.graph.proto + ") Checked all states: " + count);
        if (!job.noProgress) {
            Set<Set<Integer>> termsets = this.graph.getTerminalSets();
            for (Set<Integer> termset : termsets) {
                Map<Role, Set<ESend>> ignored;
                Set<Role> starved = SModel.checkRoleProgress(states, init, termset);
                if (!starved.isEmpty()) {
                    errorMsg = errorMsg + "\nRole progress violation for " + starved + " in session state terminal set:\n    " + this.termSetToString(job, termset, states);
                }
                if ((ignored = SModel.checkEventualReception(states, init, termset)).isEmpty()) continue;
                errorMsg = errorMsg + "\nEventual reception violation for " + ignored + " in session state terminal set:\n    " + this.termSetToString(job, termset, states);
            }
        }
        if (!errorMsg.equals("")) {
            throw new ScribbleException(errorMsg);
        }
    }

    private String termSetToString(Job job, Set<Integer> termset, Map<Integer, SState> all) {
        return job.debug ? termset.stream().map(i -> ((SState)all.get(i)).toString()).collect(Collectors.joining(",")) : termset.stream().map(i -> new Integer(((SState)all.get((Object)i)).id).toString()).collect(Collectors.joining(","));
    }

    private static Set<Role> checkRoleProgress(Map<Integer, SState> states, SState init, Set<Integer> termset) throws ScribbleException {
        HashSet<Role> starved = new HashSet<Role>();
        Iterator<Integer> i = termset.iterator();
        SState s = states.get(i.next());
        HashMap ss = new HashMap();
        s.config.efsms.keySet().forEach(r -> ss.put((Role)r, s));
        while (i.hasNext()) {
            SState next = states.get(i.next());
            Map<Role, EFSM> tmp = next.config.efsms;
            block1: for (Role r2 : tmp.keySet()) {
                if (ss.get(r2) == null) continue;
                for (SAction a : next.getAllActions()) {
                    if (!a.containsRole(r2)) continue;
                    ss.put(r2, null);
                    continue block1;
                }
            }
        }
        for (Role r3 : ss.keySet()) {
            EFSM tmp;
            SState foo = (SState)ss.get(r3);
            if (foo == null || (tmp = foo.config.efsms.get(r3)) == null || foo.config.canSafelyTerminate(r3) || !s.config.buffs.get(r3).values().stream().allMatch(v -> v == null)) continue;
            starved.add(r3);
        }
        return starved;
    }

    private static Map<Role, Set<ESend>> checkEventualReception(Map<Integer, SState> states, SState init, Set<Integer> termset) throws ScribbleException {
        Set<Role> roles = states.get((Object)termset.iterator().next()).config.efsms.keySet();
        Iterator<Integer> i = termset.iterator();
        Map<Role, Map<Role, ESend>> b0 = states.get((Object)i.next()).config.buffs.getBuffers();
        while (i.hasNext()) {
            SState s = states.get(i.next());
            SBuffers b = s.config.buffs;
            for (Role r1 : roles) {
                for (Role r2 : roles) {
                    ESend tmp;
                    ESend s0 = b0.get(r1).get(r2);
                    if (s0 == null || (tmp = b.get(r1).get(r2)) != null) continue;
                    b0.get(r1).put(r2, null);
                }
            }
        }
        HashMap<Role, Set<ESend>> ignored = new HashMap<Role, Set<ESend>>();
        for (Role r1 : roles) {
            for (Role r2 : roles) {
                ESend m = b0.get(r1).get(r2);
                if (m == null) continue;
                HashSet<ESend> tmp = (HashSet<ESend>)ignored.get(r2);
                if (tmp == null) {
                    tmp = new HashSet<ESend>();
                    ignored.put(r2, tmp);
                }
                tmp.add(m);
            }
        }
        return ignored;
    }

    public String toString() {
        return this.graph.toString();
    }
}

