/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.global;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.scribble.model.MPrettyState;
import org.scribble.model.MState;
import org.scribble.model.endpoint.EState;
import org.scribble.model.endpoint.actions.EAction;
import org.scribble.model.endpoint.actions.EReceive;
import org.scribble.model.endpoint.actions.ESend;
import org.scribble.model.global.SConfig;
import org.scribble.model.global.SStateErrors;
import org.scribble.model.global.actions.SAction;
import org.scribble.sesstype.kind.Global;
import org.scribble.sesstype.name.Role;

public class SState
extends MPrettyState<Void, SAction, SState, Global> {
    public final SConfig config;

    protected SState(SConfig config) {
        super(Collections.emptySet());
        this.config = config;
    }

    public Map<Role, List<EAction>> getFireable() {
        return this.config.getFireable();
    }

    public List<SConfig> fire(Role r, EAction a) {
        return this.config.fire(r, a);
    }

    public List<SConfig> sync(Role r1, EAction a1, Role r2, EAction a2) {
        return this.config.sync(r1, a1, r2, a2);
    }

    public SStateErrors getErrors() {
        Map<Role, EReceive> stuck = this.config.getStuckMessages();
        Set<Set<Role>> waitfor = this.config.getWaitForErrors();
        Map<Role, Set<ESend>> orphs = this.config.getOrphanMessages();
        Map<Role, EState> unfinished = this.config.getUnfinishedRoles();
        return new SStateErrors(stuck, waitfor, orphs, unfinished);
    }

    @Override
    protected String getNodeLabel() {
        String labs = this.config.toString();
        return "label=\"" + this.id + ":" + labs.substring(1, labs.length() - 1) + "\"";
    }

    @Override
    public final int hashCode() {
        int hash = 79;
        hash = 31 * hash + this.config.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SState)) {
            return false;
        }
        return ((SState)o).canEquals(this) && this.config.equals(((SState)o).config);
    }

    @Override
    protected boolean canEquals(MState<?, ?, ?, ?> s) {
        return s instanceof SState;
    }

    @Override
    public String toString() {
        return this.id + ":" + this.config.toString();
    }
}

