/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.global.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.scribble.model.MAction;
import org.scribble.sesstype.Payload;
import org.scribble.sesstype.kind.Global;
import org.scribble.sesstype.name.MessageId;
import org.scribble.sesstype.name.Role;

public abstract class SAction
extends MAction<Global> {
    public final Role subj;

    public SAction(Role subj, Role obj, MessageId<?> mid, Payload payload) {
        super(obj, mid, payload);
        this.subj = subj;
    }

    public boolean isConnect() {
        return false;
    }

    public boolean isDisconnect() {
        return false;
    }

    public boolean isAccept() {
        return false;
    }

    public boolean isSend() {
        return false;
    }

    public boolean isReceive() {
        return false;
    }

    public Set<Role> getRoles() {
        return new HashSet<Role>(Arrays.asList(this.subj, this.obj));
    }

    public boolean containsRole(Role role) {
        return this.subj.equals(role) || this.obj.equals(role);
    }

    @Override
    public String toString() {
        return this.subj + this.getCommSymbol() + this.obj + ":" + this.mid + this.payload;
    }

    @Override
    public int hashCode() {
        int hash = 149;
        hash = 31 * hash + super.hashCode();
        hash = 31 * hash + this.subj.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SAction)) {
            return false;
        }
        SAction a = (SAction)o;
        return super.equals(o) && this.subj.equals(a.subj);
    }

    @Override
    public boolean canEqual(Object o) {
        return o instanceof SAction;
    }
}

