/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.net.scribsock;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.scribble.main.ScribbleRuntimeException;
import org.scribble.net.scribsock.ScribSocket;
import org.scribble.net.session.BinaryChannelWrapper;
import org.scribble.net.session.Session;
import org.scribble.net.session.SessionEndpoint;
import org.scribble.sesstype.name.Role;

public abstract class LinearSocket<S extends Session, R extends Role>
extends ScribSocket<S, R> {
    private boolean used = false;

    protected LinearSocket(SessionEndpoint<S, R> ep) {
        super(ep);
    }

    protected boolean isUsed() {
        return this.used;
    }

    protected void use() throws ScribbleRuntimeException {
        if (this.used) {
            throw new ScribbleRuntimeException("Linear socket resource already used: " + this.getClass());
        }
        this.used = true;
    }

    public void wrapClient(Role peer, Callable<? extends BinaryChannelWrapper> cons) throws IOException, ScribbleRuntimeException {
        if (this.used) {
            throw new ScribbleRuntimeException("Linear socket resource already used: " + this.getClass());
        }
        try {
            this.se.reregister(peer, cons.call());
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public static <T> T wrapClient(T s, Role peer, Callable<? extends BinaryChannelWrapper> cons) throws IOException, ScribbleRuntimeException {
        ((LinearSocket)s).wrapClient(peer, cons);
        return s;
    }

    protected void wrapServer() {
        throw new RuntimeException("TODO");
    }
}

