/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.net.session;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import org.scribble.main.ScribbleRuntimeException;
import org.scribble.net.ScribMessageFormatter;
import org.scribble.net.scribsock.ScribServerSocket;
import org.scribble.net.session.BinaryChannelEndpoint;
import org.scribble.net.session.Session;
import org.scribble.net.session.SessionEndpoint;
import org.scribble.sesstype.name.Role;

public class MPSTEndpoint<S extends Session, R extends Role>
extends SessionEndpoint<S, R> {
    public MPSTEndpoint(S sess, R self, ScribMessageFormatter smf) throws IOException, ScribbleRuntimeException {
        super(sess, self, smf);
    }

    public void connect(Role role, Callable<? extends BinaryChannelEndpoint> cons, String host, int port) throws ScribbleRuntimeException, UnknownHostException, IOException {
        MPSTEndpoint.connect(this, role, cons, host, port);
    }

    public static void connect(SessionEndpoint<?, ?> se, Role role, Callable<? extends BinaryChannelEndpoint> cons, String host, int port) throws ScribbleRuntimeException, UnknownHostException, IOException {
        if (se.init) {
            throw new ScribbleRuntimeException("Socket already initialised: " + se.getClass());
        }
        if (se.chans.containsKey(role)) {
            throw new ScribbleRuntimeException("Already connected to: " + role);
        }
        try {
            BinaryChannelEndpoint c = cons.call();
            c.initClient(se, host, port);
            se.register(role, c);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public void accept(ScribServerSocket ss, Role role) throws IOException, ScribbleRuntimeException {
        MPSTEndpoint.accept(this, ss, role);
    }

    public static void accept(SessionEndpoint<?, ?> se, ScribServerSocket ss, Role role) throws IOException, ScribbleRuntimeException {
        if (se.init) {
            throw new ScribbleRuntimeException("Socket already initialised: " + se.getClass());
        }
        if (se.chans.containsKey(role)) {
            throw new ScribbleRuntimeException("Already connected to: " + role);
        }
        se.register(role, ss.accept(se));
    }

    public void disconnect(Role role) throws IOException, ScribbleRuntimeException {
        MPSTEndpoint.disconnect(this, role);
    }

    public static void disconnect(SessionEndpoint<?, ?> se, Role role) throws IOException, ScribbleRuntimeException {
        if (!se.chans.containsKey(role)) {
            throw new ScribbleRuntimeException("Not connected to: " + role);
        }
        se.deregister(role);
    }
}

