/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.net.session;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.scribble.net.session.BinaryChannelWrapper;

public class SSLSocketChannelWrapper
extends BinaryChannelWrapper {
    private SSLEngine engine;
    private ByteBuffer EMPTY = ByteBuffer.allocate(0);
    private ByteBuffer myAppData;
    private ByteBuffer myNetData;

    private void init(InetSocketAddress addr) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, null, null);
        this.engine = sslContext.createSSLEngine(addr.getHostName(), addr.getPort());
    }

    @Override
    public void clientHandshake() throws IOException, KeyManagementException, NoSuchAlgorithmException {
        SocketChannel s = this.getSelectableChannel();
        this.init((InetSocketAddress)s.getRemoteAddress());
        this.engine.setUseClientMode(true);
        SSLSession session = this.engine.getSession();
        this.myAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
        this.myNetData = ByteBuffer.allocate(session.getPacketBufferSize());
        this.doHandshake(s, this.engine, this.myNetData);
    }

    @Override
    public void serverHandshake() throws IOException, KeyManagementException, NoSuchAlgorithmException {
        SocketChannel s = this.getSelectableChannel();
        this.init((InetSocketAddress)s.getRemoteAddress());
        throw new RuntimeException("TODO");
    }

    @Override
    public SocketChannel getSelectableChannel() {
        return (SocketChannel)super.getSelectableChannel();
    }

    @Override
    protected void writeWrappedBytes(byte[] bs) throws IOException {
        this.getSelectableChannel().write(ByteBuffer.wrap(bs));
    }

    @Override
    protected void readWrappedBytesIntoBuffer() throws IOException {
        ByteBuffer bb = this.getWrapped();
        this.getSelectableChannel().read(bb);
    }

    @Override
    public byte[] wrap(byte[] bs) throws IOException {
        Object res;
        this.myAppData.put(bs);
        this.myAppData.flip();
        this.myNetData.clear();
        while (this.myAppData.hasRemaining()) {
            res = this.engine.wrap(this.myAppData, this.myNetData);
            if (((SSLEngineResult)res).getStatus() == SSLEngineResult.Status.OK) {
                this.myAppData.compact();
                this.myAppData.flip();
                continue;
            }
            throw new RuntimeException("TODO: " + (Object)((Object)((SSLEngineResult)res).getStatus()));
        }
        this.myAppData.compact();
        this.myNetData.flip();
        res = new byte[this.myNetData.remaining()];
        System.arraycopy(this.myNetData.array(), this.myNetData.position(), res, 0, ((Object)res).length);
        return res;
    }

    @Override
    public void unwrap() throws IOException {
        ByteBuffer peerNetData = this.getWrapped();
        ByteBuffer peerAppData = this.getBuffer();
        peerNetData.flip();
        SSLEngineResult res = this.engine.unwrap(peerNetData, peerAppData);
        peerNetData.compact();
        if (res.getStatus() != SSLEngineResult.Status.OK && res.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && res.getStatus() != SSLEngineResult.Status.CLOSED) {
            throw new RuntimeException("TODO: " + (Object)((Object)res.getStatus()));
        }
    }

    private void doHandshake(SocketChannel s, SSLEngine engine, ByteBuffer myNetData) throws IOException {
        ByteBuffer peerNetData = ByteBuffer.allocate(engine.getSession().getPacketBufferSize());
        ByteBuffer peerAppData = ByteBuffer.allocate(engine.getSession().getApplicationBufferSize());
        engine.beginHandshake();
        SSLEngineResult.HandshakeStatus hs = engine.getHandshakeStatus();
        block12: while (hs != SSLEngineResult.HandshakeStatus.FINISHED && hs != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (hs) {
                case NEED_UNWRAP: {
                    boolean done = false;
                    block13: while (!done) {
                        peerNetData.flip();
                        SSLEngineResult res = engine.unwrap(peerNetData, peerAppData);
                        peerNetData.compact();
                        hs = res.getHandshakeStatus();
                        switch (res.getStatus()) {
                            case OK: {
                                done = true;
                                continue block13;
                            }
                            case BUFFER_UNDERFLOW: {
                                if (s.read(peerNetData) >= 0) continue block13;
                                throw new RuntimeException("TODO: ");
                            }
                        }
                        throw new RuntimeException("TODO: " + (Object)((Object)res.getStatus()));
                    }
                    continue block12;
                }
                case NEED_WRAP: {
                    myNetData.clear();
                    SSLEngineResult res = engine.wrap(this.EMPTY, myNetData);
                    hs = res.getHandshakeStatus();
                    switch (res.getStatus()) {
                        case OK: {
                            myNetData.flip();
                            while (myNetData.hasRemaining()) {
                                if (s.write(myNetData) >= 0) continue;
                                throw new RuntimeException("TODO: ");
                            }
                            myNetData.compact();
                            continue block12;
                        }
                    }
                    throw new RuntimeException("TODO: " + (Object)((Object)hs));
                }
                case NEED_TASK: {
                    engine.getDelegatedTask().run();
                    hs = engine.getHandshakeStatus();
                    continue block12;
                }
            }
            throw new RuntimeException("TODO: " + (Object)((Object)hs));
        }
    }

    private void doShutdown() throws SSLException, IOException {
        SocketChannel s = this.getSelectableChannel();
        this.engine.closeOutbound();
        this.myNetData.clear();
        while (!this.engine.isOutboundDone()) {
            SSLEngineResult res = this.engine.wrap(this.EMPTY, this.myNetData);
            if (res.getStatus() != SSLEngineResult.Status.CLOSED) {
                throw new RuntimeException("TODO: " + (Object)((Object)res.getStatus()));
            }
            this.myNetData.flip();
            while (this.myNetData.hasRemaining()) {
                int num1 = s.write(this.myNetData);
                if (num1 == -1) {
                    throw new RuntimeException("TODO: ");
                }
                this.myNetData.compact();
                this.myNetData.flip();
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.doShutdown();
        super.close();
    }
}

