/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.net.session;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.main.ScribbleRuntimeException;
import org.scribble.net.Buf;
import org.scribble.net.ScribMessageFormatter;
import org.scribble.net.scribsock.ScribServerSocket;
import org.scribble.net.session.BinaryChannelEndpoint;
import org.scribble.net.session.BinaryChannelWrapper;
import org.scribble.net.session.ScribInputSelector;
import org.scribble.net.session.Session;
import org.scribble.sesstype.name.Role;

public abstract class SessionEndpoint<S extends Session, R extends Role>
implements AutoCloseable {
    public final Buf<?> gc = new Buf();
    public final Session sess;
    public final Role self;
    public final ScribMessageFormatter smf;
    protected boolean init = false;
    private boolean complete = false;
    private boolean closed = false;
    protected final Map<Role, ScribServerSocket> servs = new HashMap<Role, ScribServerSocket>();
    protected final Map<Role, BinaryChannelEndpoint> chans = new HashMap<Role, BinaryChannelEndpoint>();
    private final ScribInputSelector sel;
    private final Map<Role, SelectionKey> keys = new HashMap<Role, SelectionKey>();

    public SessionEndpoint(S sess, R self, ScribMessageFormatter smf) throws IOException, ScribbleRuntimeException {
        this.sess = sess;
        this.self = self;
        this.smf = smf;
        ((Session)sess).project(this);
        this.sel = new ScribInputSelector(this);
        this.sel.start();
    }

    public synchronized void register(Role peer, BinaryChannelEndpoint c) throws IOException {
        this.sel.pause();
        SelectionKey key = this.sel.register(c.getSelectableChannel());
        key.attach(peer);
        this.keys.put(peer, key);
        this.chans.put(peer, c);
        this.sel.unpause();
    }

    public synchronized void reregister(Role peer, BinaryChannelWrapper w) throws IOException, GeneralSecurityException {
        BinaryChannelEndpoint c = this.getChannelEndpoint(peer);
        c.sync();
        this.sel.pause();
        w.wrapChannel(c);
        w.clientHandshake();
        this.chans.put(peer, w);
        this.sel.unpause();
    }

    public synchronized void deregister(Role peer) throws IOException {
        this.sel.pause();
        try {
            this.sel.deregister(this.keys.remove(peer));
            this.chans.remove(peer).close();
        }
        finally {
            this.sel.unpause();
        }
    }

    public ScribInputSelector getSelector() {
        return this.sel;
    }

    public BinaryChannelEndpoint getChannelEndpoint(Role role) {
        if (!this.chans.containsKey(role)) {
            throw new RuntimeScribbleException(this.self + " is not connected to: " + role);
        }
        return this.chans.get(role);
    }

    public void setCompleted() {
        this.complete = true;
    }

    public boolean isCompleted() {
        return this.complete;
    }

    @Override
    public synchronized void close() throws ScribbleRuntimeException {
        if (!this.closed) {
            try {
                this.closed = true;
                this.sel.close();
                this.servs.values().stream().forEach(ss -> ss.unbind());
            }
            finally {
                if (!this.isCompleted()) {
                    throw new ScribbleRuntimeException("Session not completed: " + this.self);
                }
            }
        }
    }

    public ScribServerSocket getSelfServerSocket() {
        ScribServerSocket ss = this.servs.get(this.self);
        if (ss == null) {
            throw new RuntimeScribbleException("No server registered.");
        }
        return ss;
    }

    protected Set<Role> getPeers() {
        return this.chans.keySet();
    }

    public void init() throws ScribbleRuntimeException {
        if (this.init) {
            throw new ScribbleRuntimeException("Session endpoint already initialised.");
        }
        this.init = true;
    }
}

