/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.sesstype.name;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.scribble.sesstype.kind.Kind;
import org.scribble.sesstype.name.Name;

public abstract class AbstractName<K extends Kind>
implements Name<K> {
    private static final long serialVersionUID = 1L;
    private K kind;
    private String[] elems;

    protected AbstractName(K kind, String ... elems) {
        this.kind = kind;
        this.elems = elems;
    }

    @Override
    public K getKind() {
        return this.kind;
    }

    @Override
    public int getElementCount() {
        return this.elems.length;
    }

    @Override
    public boolean isEmpty() {
        return this.elems.length == 0;
    }

    @Override
    public boolean isPrefixed() {
        return this.elems.length > 1;
    }

    @Override
    public String[] getElements() {
        return Arrays.copyOf(this.elems, this.elems.length);
    }

    @Override
    public String[] getPrefixElements() {
        return Arrays.copyOfRange(this.elems, 0, this.elems.length - 1);
    }

    @Override
    public String getLastElement() {
        return this.elems[this.elems.length - 1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractName)) {
            return false;
        }
        AbstractName n = (AbstractName)o;
        return n.canEqual(this) && this.kind.equals(n.kind) && Arrays.equals(this.elems, n.elems);
    }

    public abstract boolean canEqual(Object var1);

    public int hashCode() {
        int hash = 2749;
        hash = 31 * hash + this.kind.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.elems);
        return hash;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        String name = this.elems[0];
        for (int i = 1; i < this.elems.length; ++i) {
            name = name + "." + this.elems[i];
        }
        return name;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.kind);
        out.writeObject(this.elems);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Kind k = (Kind)in.readObject();
        this.kind = k;
        this.elems = (String[])in.readObject();
    }
}

