/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.scribble.ast.ScribNode;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.main.ScribbleException;

public class ScribUtil {
    public static <C extends ScribNode> C checkNodeClassEquality(C c, ScribNode n) {
        if (!c.getClass().equals(n.getClass())) {
            throw new RuntimeException("Node class not equal: " + c.getClass() + ", " + n.getClass());
        }
        ScribNode tmp = n;
        return (C)tmp;
    }

    public static <C extends ScribNode> C castNodeByClass(C cast, ScribNode n) {
        if (!cast.getClass().isAssignableFrom(n.getClass())) {
            throw new RuntimeException("Node class cast error: " + cast.getClass() + ", " + n.getClass());
        }
        ScribNode tmp = n;
        return (C)tmp;
    }

    public static <N extends ScribNode> List<N> cloneList(List<N> ns) {
        return ns.stream().map(n -> ScribUtil.checkNodeClassEquality(n, n.clone())).collect(Collectors.toList());
    }

    public static <T> T handleLambdaScribbleException(Callable<T> c) {
        try {
            return c.call();
        }
        catch (Exception se) {
            throw new RuntimeScribbleException(se);
        }
    }

    public static String[] runProcess(String ... cmdAndArgs) throws ScribbleException {
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder(cmdAndArgs);
            Process p = pb.start();
            p.waitFor();
            InputStream is = p.getInputStream();
            InputStream eis = p.getErrorStream();
            InputStreamReader isr = new InputStreamReader(is);
            InputStreamReader eisr = new InputStreamReader(eis);
            BufferedReader br = new BufferedReader(isr);
            BufferedReader ebr = new BufferedReader(eisr);
            String stdout = "";
            String stderr = "";
            while ((line = br.readLine()) != null) {
                stdout = stdout + line + "\n";
            }
            while ((line = ebr.readLine()) != null) {
                stderr = stderr + line + "\n";
            }
            return new String[]{stdout, stderr};
        }
        catch (IOException | InterruptedException e) {
            throw new ScribbleException(e);
        }
    }

    public static void writeToFile(String path, String text) throws ScribbleException {
        File file = new File(path);
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write(text);
        }
        catch (IOException e) {
            throw new ScribbleException(e);
        }
    }
}

