/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit;

import java.util.LinkedList;
import org.scribble.ast.ProtocolDecl;
import org.scribble.ast.ScribNode;
import org.scribble.main.Job;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.visit.context.ModuleContextVisitor;
import org.scribble.visit.env.Env;

public abstract class EnvVisitor<T extends Env<?>>
extends ModuleContextVisitor {
    private LinkedList<T> envs = new LinkedList();

    public EnvVisitor(Job job) {
        super(job);
    }

    @Override
    protected final void enter(ScribNode parent, ScribNode child) throws ScribbleException {
        super.enter(parent, child);
        if (child instanceof ProtocolDecl) {
            ProtocolDecl pd = (ProtocolDecl)child;
            this.pushEnv(this.makeRootProtocolDeclEnv(pd));
        }
        this.envEnter(parent, child);
    }

    @Override
    protected final ScribNode leave(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        ScribNode n = this.envLeave(parent, child, visited);
        if (n instanceof ProtocolDecl) {
            this.envs.pop();
        }
        return super.leave(parent, child, n);
    }

    protected abstract T makeRootProtocolDeclEnv(ProtocolDecl<? extends ProtocolKind> var1);

    protected void envEnter(ScribNode parent, ScribNode child) throws ScribbleException {
    }

    protected ScribNode envLeave(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        return visited;
    }

    public boolean hasEnv() {
        return !this.envs.isEmpty();
    }

    public T peekEnv() {
        return (T)((Env)this.envs.peek());
    }

    public T peekParentEnv() {
        return (T)((Env)this.envs.get(1));
    }

    public void pushEnv(T env) {
        this.envs.push(env);
    }

    public T popEnv() {
        return (T)((Env)this.envs.pop());
    }
}

