/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.scribble.ast.InteractionSeq;
import org.scribble.ast.ProtocolBlock;
import org.scribble.ast.ProtocolDecl;
import org.scribble.ast.Recursion;
import org.scribble.ast.ScribNode;
import org.scribble.ast.global.GProtocolBlock;
import org.scribble.ast.global.GRecursion;
import org.scribble.ast.local.LProtocolBlock;
import org.scribble.ast.local.LRecursion;
import org.scribble.ast.name.simple.RecVarNode;
import org.scribble.del.ProtocolDefDel;
import org.scribble.main.Job;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.Global;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.sesstype.name.RecVar;
import org.scribble.visit.InlinedProtocolVisitor;
import org.scribble.visit.env.UnfoldingEnv;

public class InlinedProtocolUnfolder
extends InlinedProtocolVisitor<UnfoldingEnv> {
    public static final String DUMMY_REC_LABEL = "__";
    private Map<RecVar, Recursion<?>> recs = new HashMap();
    private Set<RecVar> recsToUnfold = new HashSet<RecVar>();

    public InlinedProtocolUnfolder(Job job) {
        super(job);
    }

    public boolean shouldUnfoldForUnguardedRec(RecVar rv) {
        return this.recsToUnfold.contains(rv);
    }

    public boolean isContinueUnguarded(RecVar rv) {
        return ((UnfoldingEnv)this.peekEnv()).shouldUnfold();
    }

    @Override
    protected UnfoldingEnv makeRootProtocolDeclEnv(ProtocolDecl<? extends ProtocolKind> pd) {
        return new UnfoldingEnv();
    }

    @Override
    public ScribNode visit(ScribNode parent, ScribNode child) throws ScribbleException {
        if (child instanceof Recursion) {
            if (((UnfoldingEnv)this.peekEnv()).shouldUnfold()) {
                this.enter(parent, child);
                ScribNode visited = this.unfold((Recursion)child);
                return this.leave(parent, child, visited);
            }
            return super.visit(parent, child);
        }
        ScribNode visited = super.visit(parent, child);
        if (visited instanceof ProtocolDecl) {
            ProtocolDecl pd = (ProtocolDecl)visited;
            this.job.debugPrintln("\n[DEBUG] Unfolded inlined protocol " + pd.getFullMemberName(this.job.getContext().getModule(this.getModuleContext().root)) + ":\n" + ((ProtocolDefDel)pd.def.del()).getInlinedProtocolDef());
        }
        return visited;
    }

    private <K extends ProtocolKind> ScribNode unfold(Recursion<K> rec) throws ScribbleException {
        RecVar rv = rec.recvar.toName();
        ProtocolBlock pb = rec.block;
        this.recsToUnfold.add(rv);
        InteractionSeq seq = pb.getInteractionSeq();
        ScribNode n = seq.accept(this);
        this.recsToUnfold.remove(rv);
        return n;
    }

    @Override
    protected void inlinedEnter(ScribNode parent, ScribNode child) throws ScribbleException {
        super.inlinedEnter(parent, child);
        child.del().enterInlinedProtocolUnfolding(parent, child, this);
    }

    @Override
    protected ScribNode inlinedLeave(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        visited = visited.del().leaveInlinedProtocolUnfolding(parent, child, this, visited);
        return super.inlinedLeave(parent, child, visited);
    }

    public Recursion<?> getRecVar(RecVar recvar) {
        return this.recs.get(recvar);
    }

    public void setRecVar(RecVar recvar, Recursion<?> rec) throws ScribbleException {
        ProtocolBlock block = (ProtocolBlock)rec.getBlock().accept(this);
        RecVarNode rv = rec.recvar.clone();
        Recursion unfolded = rec.getKind() == Global.KIND ? ((GRecursion)rec).reconstruct(rv, (ProtocolBlock)((GProtocolBlock)block)) : ((LRecursion)rec).reconstruct(rv, (ProtocolBlock)((LProtocolBlock)block));
        this.recs.put(recvar, unfolded);
    }

    public void removeRecVar(RecVar recvar) {
        this.recs.remove(recvar);
    }
}

