/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit;

import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.scribble.ast.Continue;
import org.scribble.ast.ProtocolBlock;
import org.scribble.ast.Recursion;
import org.scribble.ast.ScribNode;
import org.scribble.main.Job;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.name.RecVar;
import org.scribble.visit.InlinedProtocolVisitor;
import org.scribble.visit.env.Env;

public abstract class UnfoldingVisitor<E extends Env<?>>
extends InlinedProtocolVisitor<E> {
    private Map<RecVar, Deque<ProtocolBlock<?>>> recs = new HashMap();
    private Set<RecVar> unfolded = new HashSet<RecVar>();

    public UnfoldingVisitor(Job job) {
        super(job);
    }

    @Override
    public ScribNode visit(ScribNode parent, ScribNode child) throws ScribbleException {
        this.enter(parent, child);
        ScribNode visited = this.visitForUnfolding(parent, child);
        return this.leave(parent, child, visited);
    }

    protected ScribNode visitForUnfolding(ScribNode parent, ScribNode child) throws ScribbleException {
        if (child instanceof Continue) {
            Continue cont = (Continue)child;
            RecVar rv = cont.recvar.toName();
            if (!this.unfolded.contains(rv)) {
                this.unfolded.add(rv);
                this.recs.get((Object)rv).peek().seq.visitChildren(this);
                this.unfolded.remove(rv);
                return cont;
            }
        }
        return super.visitInlinedProtocol(parent, child);
    }

    @Override
    protected final void inlinedEnter(ScribNode parent, ScribNode child) throws ScribbleException {
        super.inlinedEnter(parent, child);
        if (child instanceof Recursion) {
            Recursion rec = (Recursion)child;
            RecVar rv = rec.recvar.toName();
            if (!this.recs.containsKey(rv)) {
                this.recs.put(rv, new LinkedList());
            }
            Deque<ProtocolBlock<?>> blocks = this.recs.get(rv);
            blocks.push(rec.block);
        }
        this.unfoldingEnter(parent, child);
    }

    @Override
    protected final ScribNode inlinedLeave(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        ScribNode n = this.unfoldingLeave(parent, child, visited);
        if (child instanceof Recursion) {
            Recursion rec = (Recursion)child;
            RecVar rv = rec.recvar.toName();
            Deque<ProtocolBlock<?>> blocks = this.recs.get(rv);
            blocks.pop();
        }
        return super.inlinedLeave(parent, child, n);
    }

    protected void unfoldingEnter(ScribNode parent, ScribNode child) throws ScribbleException {
    }

    protected ScribNode unfoldingLeave(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        return visited;
    }
}

