/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit.context;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.scribble.ast.ScribNode;
import org.scribble.main.Job;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.name.RecVar;
import org.scribble.sesstype.name.Role;
import org.scribble.visit.context.ModuleContextVisitor;
import org.scribble.visit.context.RecVarRole;

public class ProjectedChoiceSubjectFixer
extends ModuleContextVisitor {
    private Map<RecVar, Deque<Role>> recs = new HashMap<RecVar, Deque<Role>>();

    public ProjectedChoiceSubjectFixer(Job job) {
        super(job);
    }

    @Override
    protected final void enter(ScribNode parent, ScribNode child) throws ScribbleException {
        super.enter(parent, child);
        child.del().enterProjectedChoiceSubjectFixing(parent, child, this);
    }

    @Override
    protected ScribNode leave(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        visited = visited.del().leaveProjectedChoiceSubjectFixing(parent, child, this, visited);
        return super.leave(parent, child, visited);
    }

    public Role getChoiceSubject(RecVar rv) {
        return this.recs.get(rv).peek();
    }

    public void setChoiceSubject(Role subj) {
        for (Deque<Role> rs : this.recs.values()) {
            if (rs.isEmpty() || rs.peek() != null) continue;
            rs.pop();
            rs.push(subj);
        }
    }

    public void pushRec(RecVar rv) {
        Deque<Role> tmp = this.recs.get(rv);
        if (tmp == null) {
            tmp = new LinkedList<Role>();
            this.recs.put(rv, tmp);
        }
        tmp.push(null);
    }

    public void popRec(RecVar rv) {
        this.recs.get(rv).pop();
    }

    public RecVarRole createRecVarRole(RecVar rv) {
        return new RecVarRole(rv.toString());
    }

    public boolean isRecVarRole(Role r) {
        return r instanceof RecVarRole;
    }
}

