/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.tree.CommonTree;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.Module;
import org.scribble.ast.ProtocolDecl;
import org.scribble.ast.ScribNode;
import org.scribble.ast.global.GProtocolDecl;
import org.scribble.ast.name.qualified.LProtocolNameNode;
import org.scribble.ast.name.qualified.ModuleNameNode;
import org.scribble.main.Job;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.Local;
import org.scribble.sesstype.kind.ModuleKind;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.LProtocolName;
import org.scribble.sesstype.name.ModuleName;
import org.scribble.sesstype.name.Role;
import org.scribble.visit.EnvVisitor;
import org.scribble.visit.context.env.ProjectionEnv;

public class Projector
extends EnvVisitor<ProjectionEnv> {
    private Stack<Role> selfs = new Stack();
    private Map<GProtocolName, Map<Role, Module>> projections = new HashMap<GProtocolName, Map<Role, Module>>();

    public Projector(Job job) {
        super(job);
    }

    @Override
    protected ProjectionEnv makeRootProtocolDeclEnv(ProtocolDecl<? extends ProtocolKind> pd) {
        return new ProjectionEnv();
    }

    @Override
    public ScribNode visit(ScribNode parent, ScribNode child) throws ScribbleException {
        if (child instanceof GProtocolDecl) {
            return this.visitOverrideForGProtocolDecl((Module)parent, (GProtocolDecl)child);
        }
        return super.visit(parent, child);
    }

    protected GProtocolDecl visitOverrideForGProtocolDecl(Module parent, GProtocolDecl child) throws ScribbleException {
        for (Role self : child.header.roledecls.getRoles()) {
            this.pushSelf(self);
            this.enter(parent, child);
            GProtocolDecl visited = (GProtocolDecl)child.visitChildren(this);
            visited = (GProtocolDecl)this.leave(parent, child, visited);
            this.popSelf();
        }
        return child;
    }

    @Override
    protected final void envEnter(ScribNode parent, ScribNode child) throws ScribbleException {
        super.envEnter(parent, child);
        child.del().enterProjection(parent, child, this);
    }

    @Override
    protected ScribNode envLeave(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        visited = visited.del().leaveProjection(parent, child, this, visited);
        return super.envLeave(parent, child, visited);
    }

    public void pushSelf(Role self) {
        this.selfs.push(self);
    }

    public Role peekSelf() {
        return this.selfs.peek();
    }

    public Role popSelf() {
        return this.selfs.pop();
    }

    public void addProjection(GProtocolName gpn, Role role, Module mod) {
        Map<Role, Module> tmp = this.projections.get(gpn);
        if (tmp == null) {
            tmp = new HashMap<Role, Module>();
            this.projections.put(gpn, tmp);
        }
        tmp.put(role, mod);
    }

    public Map<GProtocolName, Map<Role, Module>> getProjections() {
        return this.projections;
    }

    public static LProtocolName projectSimpleProtocolName(GProtocolName simpname, Role role) {
        return new LProtocolName(simpname.toString() + "_" + role.toString());
    }

    public static LProtocolName projectFullProtocolName(GProtocolName fullname, Role role) {
        LProtocolName simplename = Projector.projectSimpleProtocolName(fullname.getSimpleName(), role);
        ModuleName modname = Projector.projectModuleName(fullname.getPrefix(), simplename);
        return new LProtocolName(modname, simplename);
    }

    public static ModuleName projectModuleName(ModuleName fullname, LProtocolName localname) {
        ModuleName simpname = new ModuleName(fullname.getSimpleName().toString() + "_" + localname.toString());
        return new ModuleName(fullname.getPrefix(), simpname);
    }

    public static LProtocolNameNode makeProjectedSimpleNameNode(CommonTree source, GProtocolName simpname, Role role) {
        return (LProtocolNameNode)AstFactoryImpl.FACTORY.QualifiedNameNode(source, Local.KIND, Projector.projectSimpleProtocolName(simpname, role).toString());
    }

    public static LProtocolNameNode makeProjectedFullNameNode(CommonTree source, GProtocolName fullname, Role role) {
        return (LProtocolNameNode)AstFactoryImpl.FACTORY.QualifiedNameNode(source, Local.KIND, Projector.projectFullProtocolName(fullname, role).getElements());
    }

    public static ModuleNameNode makeProjectedModuleNameNode(CommonTree source, ModuleName fullname, LProtocolName localname) {
        return (ModuleNameNode)AstFactoryImpl.FACTORY.QualifiedNameNode(source, ModuleKind.KIND, Projector.projectModuleName(fullname, localname).getElements());
    }
}

