/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit.context;

import org.scribble.ast.ProtocolDecl;
import org.scribble.ast.ScribNode;
import org.scribble.ast.context.ModuleContext;
import org.scribble.ast.local.LChoice;
import org.scribble.ast.local.LDo;
import org.scribble.ast.local.LInteractionNode;
import org.scribble.ast.local.LProtocolBlock;
import org.scribble.main.Job;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.SubprotocolSig;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.sesstype.name.ProtocolName;
import org.scribble.visit.SubprotocolVisitor;
import org.scribble.visit.context.env.UnguardedChoiceDoEnv;

public class UnguardedChoiceDoProjectionChecker
extends SubprotocolVisitor<UnguardedChoiceDoEnv> {
    private boolean shouldPrune = false;

    public UnguardedChoiceDoProjectionChecker(Job job, ModuleContext mcontext, LChoice cho) {
        super(job);
        this.setModuleContext(mcontext);
    }

    public void setPruneCheck() {
        this.shouldPrune = true;
    }

    public boolean shouldCheckPrune() {
        return this.shouldPrune;
    }

    @Override
    protected UnguardedChoiceDoEnv makeRootProtocolDeclEnv(ProtocolDecl<? extends ProtocolKind> pd) {
        return new UnguardedChoiceDoEnv();
    }

    @Override
    public ScribNode visit(ScribNode parent, ScribNode child) throws ScribbleException {
        if (child instanceof LChoice) {
            LChoice lc = (LChoice)child;
            return this.visitOverrideForLDoPruning(parent, lc);
        }
        return super.visit(parent, child);
    }

    private ScribNode visitOverrideForLDoPruning(ScribNode parent, LChoice lc) throws ScribbleException {
        for (LProtocolBlock b : lc.getBlocks()) {
            LInteractionNode in = b.getInteractionSeq().getInteractions().get(0);
            if (!(in instanceof LDo)) continue;
            LDo ld = (LDo)in;
            ProtocolName fullname = this.getModuleContext().checkProtocolDeclDependencyFullName(ld.proto.toName());
            SubprotocolSig sig = new SubprotocolSig(fullname, ld.roles.getRoles(), ld.args.getArguments());
            if (!sig.equals(this.getStack().get(0))) continue;
            this.setPruneCheck();
            return lc;
        }
        return super.visit(parent, lc);
    }

    @Override
    protected void subprotocolEnter(ScribNode parent, ScribNode child) throws ScribbleException {
        super.subprotocolEnter(parent, child);
        child.del().enterUnguardedChoiceDoProjectionCheck(parent, child, this);
    }

    @Override
    protected ScribNode subprotocolLeave(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        visited = visited.del().leaveUnguardedChoiceDoProjectionCheck(parent, child, this, visited);
        return super.subprotocolLeave(parent, child, visited);
    }
}

