/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit.wf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.scribble.ast.ScribNode;
import org.scribble.ast.global.GDelegationElem;
import org.scribble.del.global.GDelegationElemDel;
import org.scribble.main.Job;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.NonRoleArgKind;
import org.scribble.sesstype.kind.NonRoleParamKind;
import org.scribble.sesstype.name.Name;
import org.scribble.sesstype.name.RecVar;
import org.scribble.sesstype.name.Role;
import org.scribble.visit.context.ModuleContextVisitor;

public class NameDisambiguator
extends ModuleContextVisitor {
    private Set<Role> roles = new HashSet<Role>();
    private Map<String, NonRoleParamKind> params = new HashMap<String, NonRoleParamKind>();
    private Map<RecVar, Integer> recvars = new HashMap<RecVar, Integer>();

    public NameDisambiguator(Job job) {
        super(job);
    }

    @Override
    public ScribNode visit(ScribNode parent, ScribNode child) throws ScribbleException {
        this.enter(parent, child);
        ScribNode visited = this.visitForDisamb(parent, child);
        return this.leave(parent, child, visited);
    }

    protected ScribNode visitForDisamb(ScribNode parent, ScribNode child) throws ScribbleException {
        if (child instanceof GDelegationElem) {
            return ((GDelegationElemDel)child.del()).visitForNameDisambiguation(this, (GDelegationElem)child);
        }
        return child.visitChildren(this);
    }

    @Override
    public void enter(ScribNode parent, ScribNode child) throws ScribbleException {
        super.enter(parent, child);
        child.del().enterDisambiguation(parent, child, this);
    }

    @Override
    public ScribNode leave(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        visited = visited.del().leaveDisambiguation(parent, child, this, visited);
        return super.leave(parent, child, visited);
    }

    public void clear() {
        this.roles.clear();
        this.params.clear();
        this.recvars.clear();
    }

    public void addRole(Role role) {
        this.roles.add(role);
    }

    public boolean isBoundRole(Role role) {
        return this.roles.contains(role);
    }

    public void addParameter(Name<? extends NonRoleParamKind> param, NonRoleParamKind kind) {
        this.params.put(param.toString(), kind);
    }

    public boolean isBoundParameter(Name<? extends NonRoleArgKind> name) {
        return this.params.containsKey(name.toString());
    }

    public NonRoleParamKind getParameterKind(Name<? extends NonRoleArgKind> name) {
        return this.params.get(name.toString());
    }

    public void pushRecVar(RecVar rv) {
        if (!this.recvars.containsKey(rv)) {
            this.recvars.put(rv, 0);
        } else {
            this.recvars.put(rv, this.recvars.get(rv) + 1);
        }
    }

    public boolean isBoundRecVar(RecVar rv) {
        return this.recvars.containsKey(rv);
    }

    public void popRecVar(RecVar rv) {
        Integer i = this.recvars.get(rv);
        if (i == 0) {
            this.recvars.remove(rv);
        } else {
            this.recvars.put(rv, i - 1);
        }
    }
}

