/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit.wf.env;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.scribble.sesstype.name.RecVar;
import org.scribble.visit.env.Env;

public class ReachabilityEnv
extends Env<ReachabilityEnv> {
    private boolean seqable;
    private final Set<RecVar> contlabs;

    public ReachabilityEnv() {
        this(true, Collections.emptySet());
    }

    protected ReachabilityEnv(boolean seqable, Set<RecVar> contlabs) {
        this.contlabs = new HashSet<RecVar>(contlabs);
        this.seqable = seqable;
    }

    @Override
    public ReachabilityEnv copy() {
        return new ReachabilityEnv(this.seqable, this.contlabs);
    }

    @Override
    public ReachabilityEnv enterContext() {
        return this.copy();
    }

    public ReachabilityEnv mergeContext(ReachabilityEnv child) {
        return this.mergeContexts((List)Arrays.asList(child));
    }

    public ReachabilityEnv mergeContexts(List<ReachabilityEnv> children) {
        return this.merge(false, children);
    }

    public ReachabilityEnv mergeForChoice(List<ReachabilityEnv> children) {
        return this.merge(true, children);
    }

    private ReachabilityEnv merge(boolean isChoice, List<ReachabilityEnv> children) {
        ReachabilityEnv copy = this.copy();
        copy.seqable = isChoice ? children.stream().filter(e -> e.seqable).count() > 0L : children.stream().filter(e -> !e.seqable).count() == 0L;
        children.stream().forEach(e -> copy.contlabs.addAll(e.contlabs));
        return copy;
    }

    public boolean isSequenceable() {
        return this.seqable && this.contlabs.isEmpty();
    }

    public ReachabilityEnv addContinueLabel(RecVar recvar) {
        ReachabilityEnv copy = this.copy();
        copy.seqable = false;
        copy.contlabs.add(recvar);
        return copy;
    }

    public ReachabilityEnv removeContinueLabel(RecVar recvar) {
        ReachabilityEnv copy = this.copy();
        copy.contlabs.remove(recvar);
        return copy;
    }
}

