/*
 * Decompiled with CFR 0.152.
 */
package org.sculptor.maven.plugin;

import java.io.File;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.mockito.Mockito;
import org.sculptor.maven.plugin.AbstractGeneratorMojoTestCase;
import org.sculptor.maven.plugin.CleanMojo;

public class CleanMojoTest
extends AbstractGeneratorMojoTestCase<CleanMojo> {
    private static final String ONE_SHOT_GENERATED_FILE = "src/main/webapp/index.jsp";
    private static final String GENERATED_FILE = "src/generated/java/com/acme/test/domain/Bar.java";
    private static final String UNKNOWN_FILE = "src/generated/resources/unknown.properties";

    public void testDeleteGeneratedFilesWithoutStatusFile() throws Exception {
        CleanMojo mojo = this.createMojo(this.createProject("test1"));
        CleanMojoTest.assertTrue((boolean)mojo.deleteGeneratedFiles());
    }

    public void testDeleteGeneratedFilesAll() throws Exception {
        CleanMojo mojo = this.createMojo(this.createProject("test2"));
        CleanMojoTest.assertTrue((boolean)new File(mojo.getProject().getBasedir(), ONE_SHOT_GENERATED_FILE).exists());
        CleanMojoTest.assertTrue((boolean)mojo.deleteGeneratedFiles());
        CleanMojoTest.assertFalse((boolean)new File(mojo.getProject().getBasedir(), ONE_SHOT_GENERATED_FILE).exists());
        CleanMojoTest.assertFalse((boolean)new File(mojo.getProject().getBasedir(), GENERATED_FILE).exists());
        CleanMojoTest.assertFalse((boolean)new File(mojo.getProject().getBasedir(), UNKNOWN_FILE).exists());
    }

    public void testDeleteGeneratedFilesKeepOneShot() throws Exception {
        CleanMojo mojo = this.createMojo(this.createProject("test2"));
        File oneShotFile = new File(mojo.getProject().getBasedir(), ONE_SHOT_GENERATED_FILE);
        FileUtils.fileAppend((String)oneShotFile.getAbsolutePath(), (String)"modified");
        CleanMojoTest.assertTrue((boolean)mojo.deleteGeneratedFiles());
        CleanMojoTest.assertTrue((boolean)oneShotFile.exists());
        CleanMojoTest.assertFalse((boolean)new File(mojo.getProject().getBasedir(), GENERATED_FILE).exists());
    }

    public void testExecuteSkip() throws Exception {
        CleanMojo mojo = (CleanMojo)Mockito.spy((Object)this.createMojo(this.createProject("test1")));
        ((CleanMojo)Mockito.doThrow(Exception.class).when((Object)mojo)).deleteGeneratedFiles();
        this.setVariableValueToObject(mojo, "skip", true);
        mojo.execute();
    }

    public void testExecute() throws Exception {
        CleanMojo mojo = (CleanMojo)Mockito.spy((Object)this.createMojo(this.createProject("test2")));
        CleanMojoTest.assertTrue((boolean)new File(mojo.getProject().getBasedir(), ONE_SHOT_GENERATED_FILE).exists());
        mojo.execute();
        CleanMojoTest.assertFalse((boolean)new File(mojo.getProject().getBasedir(), ONE_SHOT_GENERATED_FILE).exists());
        CleanMojoTest.assertFalse((boolean)new File(mojo.getProject().getBasedir(), GENERATED_FILE).exists());
        CleanMojoTest.assertNull((Object)mojo.getStatusFile());
    }

    protected CleanMojo createMojo(MavenProject project) throws Exception {
        return (CleanMojo)super.createMojo(project, "clean");
    }
}

