/*
 * Decompiled with CFR 0.152.
 */
package org.sculptor.maven.plugin;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.mockito.Mockito;
import org.sculptor.maven.plugin.AbstractGeneratorMojoTestCase;
import org.sculptor.maven.plugin.GeneratorMojo;

public class GeneratorMojoTest
extends AbstractGeneratorMojoTestCase<GeneratorMojo> {
    private static final String ONE_SHOT_GENERATED_FILE = "src/main/java/com/acme/test/domain/Foo.java";
    private static final String GENERATED_FILE = "src/generated/java/com/acme/test/domain/Bar.java";

    public void testChangedFilesNoStatusFile() throws Exception {
        GeneratorMojo mojo = this.createMojo(this.createProject("test1"));
        Set changedFiles = mojo.getChangedFiles();
        GeneratorMojoTest.assertNull((Object)changedFiles);
    }

    public void testChangedFilesNoUpdatedFiles() throws Exception {
        GeneratorMojo mojo = this.createMojo(this.createProject("test2"));
        mojo.getStatusFile().setLastModified(System.currentTimeMillis() + 1000L);
        Set changedFiles = mojo.getChangedFiles();
        GeneratorMojoTest.assertNotNull((Object)changedFiles);
        GeneratorMojoTest.assertEquals((int)0, (int)changedFiles.size());
    }

    public void testChangedFilesOutdatedStatusFile() throws Exception {
        GeneratorMojo mojo = this.createMojo(this.createProject("test2"));
        mojo.getStatusFile().setLastModified(0L);
        Set changedFiles = mojo.getChangedFiles();
        GeneratorMojoTest.assertNotNull((Object)changedFiles);
        GeneratorMojoTest.assertEquals((int)5, (int)changedFiles.size());
    }

    public void testChangedFilesUpdatedWorkflowDescriptor() throws Exception {
        GeneratorMojo mojo = this.createMojo(this.createProject("test2"));
        mojo.getStatusFile().setLastModified(System.currentTimeMillis() + 1000L);
        mojo.getModelFile().setLastModified(System.currentTimeMillis() + 2000L);
        Set changedFiles = mojo.getChangedFiles();
        GeneratorMojoTest.assertNotNull((Object)changedFiles);
        GeneratorMojoTest.assertEquals((int)1, (int)changedFiles.size());
    }

    public void testChangedFilesUpdatedGeneratorConfigFiles() throws Exception {
        GeneratorMojo mojo = this.createMojo(this.createProject("test2"));
        mojo.getStatusFile().setLastModified(System.currentTimeMillis() + 1000L);
        new File(mojo.getProject().getBasedir(), "/src/main/resources/generator/java-code-formatter.properties").setLastModified(System.currentTimeMillis() + 2000L);
        new File(mojo.getProject().getBasedir(), "/src/main/resources/generator/sculptor-generator.properties").setLastModified(System.currentTimeMillis() + 2000L);
        Set changedFiles = mojo.getChangedFiles();
        GeneratorMojoTest.assertNotNull((Object)changedFiles);
        GeneratorMojoTest.assertEquals((int)2, (int)changedFiles.size());
    }

    public void testUpdateStatusFile() throws Exception {
        GeneratorMojo mojo = this.createMojo(this.createProject("test2"));
        ArrayList<File> files = new ArrayList<File>();
        files.add(new File(mojo.getProject().getBasedir(), ONE_SHOT_GENERATED_FILE));
        files.add(new File(mojo.getProject().getBasedir(), GENERATED_FILE));
        GeneratorMojoTest.assertTrue((boolean)mojo.updateStatusFile(files));
        Properties statusFileProps = new Properties();
        statusFileProps.load(new FileReader(mojo.getStatusFile()));
        GeneratorMojoTest.assertEquals((int)2, (int)statusFileProps.size());
        GeneratorMojoTest.assertEquals((String)"e747f800870423a6c554ae2ec80aeeb6", (String)statusFileProps.getProperty(ONE_SHOT_GENERATED_FILE));
        GeneratorMojoTest.assertEquals((String)"7d436134142a2e69dfc98eb9f22f5907", (String)statusFileProps.getProperty(GENERATED_FILE));
    }

    public void testExecuteSkip() throws Exception {
        GeneratorMojo mojo = this.createMojo(this.createProject("test1"));
        ((GeneratorMojo)Mockito.doThrow(AssertionFailedError.class).when((Object)mojo)).executeGenerator();
        this.setVariableValueToObject(mojo, "skip", true);
        mojo.execute();
    }

    public void testExecuteForce() throws Exception {
        GeneratorMojo mojo = this.createMojo(this.createProject("test2"));
        ((GeneratorMojo)Mockito.doThrow((Throwable)new RuntimeException("testExecuteForce")).when((Object)mojo)).doRunGenerator();
        this.setVariableValueToObject(mojo, "force", true);
        try {
            mojo.execute();
        }
        catch (MojoExecutionException e) {
            return;
        }
        GeneratorMojoTest.fail();
    }

    public void testExecuteWithClean() throws Exception {
        GeneratorMojo mojo = this.createMojo(this.createProject("test2"));
        ((GeneratorMojo)Mockito.doThrow((Throwable)new RuntimeException("testExecuteWithClean")).when((Object)mojo)).doRunGenerator();
        mojo.getStatusFile().setLastModified(System.currentTimeMillis() + 1000L);
        mojo.getModelFile().setLastModified(System.currentTimeMillis() + 2000L);
        this.setVariableValueToObject(mojo, "clean", true);
        try {
            mojo.execute();
        }
        catch (MojoExecutionException e) {
            GeneratorMojoTest.assertFalse((boolean)new File(mojo.getProject().getBasedir(), ONE_SHOT_GENERATED_FILE).exists());
            GeneratorMojoTest.assertFalse((boolean)new File(mojo.getProject().getBasedir(), GENERATED_FILE).exists());
            return;
        }
        GeneratorMojoTest.fail();
    }

    public void testExecuteWithoutClean() throws Exception {
        GeneratorMojo mojo = this.createMojo(this.createProject("test2"));
        ((GeneratorMojo)Mockito.doThrow((Throwable)new RuntimeException("testExecuteWithoutClean")).when((Object)mojo)).doRunGenerator();
        mojo.getStatusFile().setLastModified(System.currentTimeMillis() + 1000L);
        mojo.getModelFile().setLastModified(System.currentTimeMillis() + 2000L);
        this.setVariableValueToObject(mojo, "clean", false);
        try {
            mojo.execute();
        }
        catch (MojoExecutionException e) {
            GeneratorMojoTest.assertTrue((boolean)new File(mojo.getProject().getBasedir(), ONE_SHOT_GENERATED_FILE).exists());
            GeneratorMojoTest.assertTrue((boolean)new File(mojo.getProject().getBasedir(), GENERATED_FILE).exists());
            return;
        }
        GeneratorMojoTest.fail();
    }

    public void testExecuteWithProperties() throws Exception {
        GeneratorMojo mojo = this.createMojo(this.createProject("test2"));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("testExecuteWithProperties", "testExecuteWithProperties-value");
        this.setVariableValueToObject(mojo, "properties", properties);
        this.setVariableValueToObject(mojo, "force", true);
        mojo.execute();
        GeneratorMojoTest.assertEquals((String)"testExecuteWithProperties-value", (String)System.getProperty("testExecuteWithProperties"));
    }

    protected GeneratorMojo createMojo(MavenProject project) throws Exception {
        GeneratorMojo mojo = (GeneratorMojo)Mockito.spy(super.createMojo(project, "generate"));
        ((GeneratorMojo)Mockito.doReturn((Object)Boolean.TRUE).when((Object)mojo)).doRunGenerator();
        this.setVariableValueToObject(mojo, "model", "src/main/resources/model.btdesign");
        this.setVariableValueToObject(mojo, "clean", true);
        mojo.initMojoMultiValueParameters();
        return mojo;
    }
}

