/*
 * Decompiled with CFR 0.152.
 */
package org.sculptor.maven.plugin;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.apache.commons.exec.CommandLine;
import org.apache.maven.project.MavenProject;
import org.mockito.Mockito;
import org.sculptor.maven.plugin.AbstractGeneratorMojoTestCase;
import org.sculptor.maven.plugin.GraphvizMojo;

public class GraphvizMojoTest
extends AbstractGeneratorMojoTestCase<GraphvizMojo> {
    private static final String GENERATED_FILE = "src/generated/resources/umlgraph-dependencies.dot";

    public void testChangedDotFilesNoStatusFile() throws Exception {
        GraphvizMojo mojo = this.createMojo(this.createProject("test1"));
        Set changedDotFiles = mojo.getChangedDotFiles();
        GraphvizMojoTest.assertNull((Object)changedDotFiles);
    }

    public void testChangedDotFilesUpdatedImageFile() throws Exception {
        GraphvizMojo mojo = this.createMojo(this.createProject("test2"));
        File dotFile = new File(mojo.getProject().getBasedir(), GENERATED_FILE);
        dotFile.setLastModified(System.currentTimeMillis() + 1000L);
        Set changedDotFiles = mojo.getChangedDotFiles();
        GraphvizMojoTest.assertNotNull((Object)changedDotFiles);
        GraphvizMojoTest.assertEquals((int)3, (int)changedDotFiles.size());
    }

    public void testChangedDotFilesMissingImageFiles() throws Exception {
        GraphvizMojo mojo = this.createMojo(this.createProject("test2"));
        mojo.getStatusFile().setLastModified(0L);
        Set changedDotFiles = mojo.getChangedDotFiles();
        GraphvizMojoTest.assertNotNull((Object)changedDotFiles);
        GraphvizMojoTest.assertEquals((int)2, (int)changedDotFiles.size());
    }

    public void testDotCommandLine() throws Exception {
        GraphvizMojo mojo = this.createMojo(this.createProject("test1"));
        this.setVariableValueToObject(mojo, "verbose", false);
        HashSet<String> changedDotFiles = new HashSet<String>();
        changedDotFiles.add("file1.dot");
        changedDotFiles.add("file2.dot");
        changedDotFiles.add("file3.dot");
        CommandLine commandline = mojo.getDotCommandLine(changedDotFiles);
        GraphvizMojoTest.assertNotNull((Object)commandline);
        String[] arguments = commandline.getArguments();
        GraphvizMojoTest.assertEquals((int)5, (int)arguments.length);
        GraphvizMojoTest.assertEquals((String)"-Tpng", (String)arguments[0]);
        GraphvizMojoTest.assertEquals((String)"-O", (String)arguments[1]);
        GraphvizMojoTest.assertEquals((String)"file1.dot", (String)arguments[2]);
        GraphvizMojoTest.assertEquals((String)"file2.dot", (String)arguments[3]);
        GraphvizMojoTest.assertEquals((String)"file3.dot", (String)arguments[4]);
    }

    public void testVerboseDotCommandLine() throws Exception {
        GraphvizMojo mojo = this.createMojo(this.createProject("test1"));
        this.setVariableValueToObject(mojo, "verbose", true);
        HashSet<String> changedDotFiles = new HashSet<String>();
        changedDotFiles.add("file1.dot");
        changedDotFiles.add("file2.dot");
        changedDotFiles.add("file3.dot");
        CommandLine commandline = mojo.getDotCommandLine(changedDotFiles);
        GraphvizMojoTest.assertNotNull((Object)commandline);
        String[] arguments = commandline.getArguments();
        GraphvizMojoTest.assertEquals((int)6, (int)arguments.length);
        GraphvizMojoTest.assertEquals((String)"-v", (String)arguments[0]);
        GraphvizMojoTest.assertEquals((String)"-Tpng", (String)arguments[1]);
        GraphvizMojoTest.assertEquals((String)"-O", (String)arguments[2]);
        GraphvizMojoTest.assertEquals((String)"file1.dot", (String)arguments[3]);
        GraphvizMojoTest.assertEquals((String)"file2.dot", (String)arguments[4]);
        GraphvizMojoTest.assertEquals((String)"file3.dot", (String)arguments[5]);
    }

    public void testExecuteSkip() throws Exception {
        GraphvizMojo mojo = (GraphvizMojo)Mockito.spy((Object)this.createMojo(this.createProject("test1")));
        ((GraphvizMojo)Mockito.doThrow(AssertionFailedError.class).when((Object)mojo)).getChangedDotFiles();
        this.setVariableValueToObject(mojo, "skip", true);
        mojo.execute();
    }

    protected GraphvizMojo createMojo(MavenProject project) throws Exception {
        GraphvizMojo mojo = (GraphvizMojo)super.createMojo(project, "generate-images");
        this.setVariableValueToObject(mojo, "command", "dot");
        return mojo;
    }
}

