/*
 * Decompiled with CFR 0.152.
 */
package org.sculptor.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.testing.stubs.MavenProjectStub;

public class MojoProjectStub
extends MavenProjectStub {
    private File projectDir;
    private Properties properties = new Properties();

    public MojoProjectStub(File projectDir) {
        this.projectDir = projectDir;
        String basedir = projectDir.getAbsolutePath();
        this.getProperties().setProperty("basedir", basedir);
        File pom = new File(this.getBasedir(), "pom.xml");
        this.setFile(pom);
        this.readModel(pom);
        Model model = this.getModel();
        this.setGroupId(model.getGroupId());
        this.setArtifactId(model.getArtifactId());
        this.setVersion(model.getVersion());
        this.setName(model.getName());
        this.setUrl(model.getUrl());
        this.setPackaging(model.getPackaging());
        Build build = model.getBuild();
        build.setFinalName(model.getArtifactId());
        build.setDirectory(basedir + "/target");
        build.setSourceDirectory(basedir + "/src/main/java");
        build.setOutputDirectory(basedir + "/target/classes");
        build.setTestSourceDirectory(basedir + "/src/test/java");
        build.setTestOutputDirectory(basedir + "/target/test-classes");
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Resource resource = new Resource();
        resource.setDirectory(basedir + "/src/main/resources");
        resources.add(resource);
        build.setResources(resources);
        ArrayList<Resource> testResources = new ArrayList<Resource>();
        Resource testResource = new Resource();
        testResource.setDirectory(basedir + "/src/test/resources");
        testResources.add(testResource);
        build.setTestResources(testResources);
        this.setBuild(build);
    }

    public File getBasedir() {
        return this.projectDir;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public List<Dependency> getDependencies() {
        return this.getModel().getDependencies();
    }

    public List<Resource> getResources() {
        return this.getBuild().getResources();
    }

    public List<Resource> getTestResources() {
        return this.getBuild().getTestResources();
    }
}

