/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.auth.testing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.sdase.commons.server.auth.config.AuthConfig;
import org.sdase.commons.server.auth.testing.AbstractAuth;
import org.sdase.commons.server.auth.testing.AuthBuilder;
import org.sdase.commons.server.testing.Environment;

public class AuthClassExtension
extends AbstractAuth
implements BeforeAllCallback,
AfterAllCallback {
    private static final String AUTH_RULE_ENV_KEY = "AUTH_RULE";
    private static final String DEFAULT_KEY_ID = AuthClassExtension.class.getSimpleName();
    private static final String DEFAULT_ISSUER = "AuthExtension";
    private static final String DEFAULT_SUBJECT = "test";
    private static final String DEFAULT_INTERNAL_KEY_PATH = "/org/sdase/commons/server/auth/testing";
    private static final String DEFAULT_PRIVATE_KEY_LOCATION = Objects.requireNonNull(AuthClassExtension.class.getResource("/org/sdase/commons/server/auth/testing/rsa-private.key")).toString();
    private static final String DEFAULT_CERTIFICATE_LOCATION = Objects.requireNonNull(AuthClassExtension.class.getResource("/org/sdase/commons/server/auth/testing/rsa-x.509.pem")).toString();
    private String valueToRestore;

    public static AuthExtensionBuilder builder() {
        return new Builder();
    }

    private AuthClassExtension(boolean disableAuth, String keyId, String issuer, String subject, String certificateLocation, String privateKeyLocation) {
        super(disableAuth, keyId, issuer, subject, privateKeyLocation, certificateLocation);
        if (disableAuth) {
            this.initDisabledTestAuth();
        } else {
            this.initEnabledTestAuth();
        }
    }

    public AuthBuilder auth() {
        if (this.disableAuth) {
            throw new IllegalStateException("Could not create token when auth is disabled.");
        }
        return new AuthBuilder(this.keyId, this.privateKey).withIssuer(this.issuer).withSubject(this.subject);
    }

    public void beforeAll(ExtensionContext context) {
        this.valueToRestore = this.getCurrentValueForAuthRuleEnv();
    }

    public void afterAll(ExtensionContext context) {
        this.setValueForAuthRuleEnv(this.valueToRestore);
    }

    private void initDisabledTestAuth() {
        this.authConfig = new AuthConfig().setDisableAuth(true);
        this.setValueForAuthRuleEnv("{\"disableAuth\": true}");
    }

    private void initEnabledTestAuth() {
        this.privateKey = this.loadPrivateKey(this.privateKeyLocation);
        this.authConfig = new AuthConfig().setKeys(Collections.singletonList(this.createKeyLocation()));
        try {
            String authKeysConfig = new ObjectMapper().writeValueAsString((Object)this.authConfig);
            this.setValueForAuthRuleEnv(authKeysConfig);
        }
        catch (JsonProcessingException e) {
            Assert.fail((String)("Failed to create the config keys: " + e.getMessage()));
        }
    }

    private String getCurrentValueForAuthRuleEnv() {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16)) {
            return System.getProperty(AUTH_RULE_ENV_KEY);
        }
        return System.getenv(AUTH_RULE_ENV_KEY);
    }

    private void setValueForAuthRuleEnv(String value) {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16)) {
            System.setProperty(AUTH_RULE_ENV_KEY, value);
        } else {
            Environment.setEnv((String)AUTH_RULE_ENV_KEY, (String)value);
        }
    }

    static /* synthetic */ String access$100() {
        return DEFAULT_KEY_ID;
    }

    static /* synthetic */ String access$200() {
        return DEFAULT_CERTIFICATE_LOCATION;
    }

    static /* synthetic */ String access$300() {
        return DEFAULT_PRIVATE_KEY_LOCATION;
    }

    public static class Builder
    implements AuthExtensionBuilder,
    DisabledBuilder {
        private boolean disableAuth;
        private String keyId = AuthClassExtension.access$100();
        private String issuer = "AuthExtension";
        private String subject = "test";
        private String publicKeyCertificateLocation = AuthClassExtension.access$200();
        private String privateKeyLocation = AuthClassExtension.access$300();

        private Builder() {
        }

        @Override
        public AuthExtensionBuilder withKeyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        @Override
        public AuthExtensionBuilder withIssuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        @Override
        public AuthExtensionBuilder withSubject(String subject) {
            this.subject = subject;
            return this;
        }

        @Override
        public AuthExtensionBuilder withCustomKeyPair(String publicKeyCertificateLocation, String privateKeyLocation) {
            this.publicKeyCertificateLocation = publicKeyCertificateLocation;
            this.privateKeyLocation = privateKeyLocation;
            return this;
        }

        @Override
        public DisabledBuilder withDisabledAuth() {
            this.disableAuth = true;
            return this;
        }

        @Override
        public AuthClassExtension build() {
            return new AuthClassExtension(this.disableAuth, this.keyId, this.issuer, this.subject, this.publicKeyCertificateLocation, this.privateKeyLocation);
        }
    }

    public static interface DisabledBuilder {
        public AuthClassExtension build();
    }

    public static interface AuthExtensionBuilder {
        public AuthExtensionBuilder withKeyId(String var1);

        public AuthExtensionBuilder withIssuer(String var1);

        public AuthExtensionBuilder withSubject(String var1);

        public AuthExtensionBuilder withCustomKeyPair(String var1, String var2);

        public DisabledBuilder withDisabledAuth();

        public AuthClassExtension build();
    }
}

