/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.auth.testing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.Configuration;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.sdase.commons.server.auth.config.AuthConfig;
import org.sdase.commons.server.auth.testing.AbstractAuth;
import org.sdase.commons.server.auth.testing.AuthBuilder;
import org.sdase.commons.server.testing.EnvironmentRule;
import org.sdase.commons.server.testing.SystemPropertyRule;

@Deprecated
public class AuthRule
extends AbstractAuth
implements TestRule {
    public static final String AUTH_RULE_ENV_KEY = "AUTH_RULE";
    private static final String DEFAULT_KEY_ID = AuthRule.class.getSimpleName();
    private static final String DEFAULT_ISSUER = "AuthRule";
    private static final String DEFAULT_SUBJECT = "test";
    private static final String DEFAULT_INTERNAL_KEY_PATH = "/org/sdase/commons/server/auth/testing";
    private static final String DEFAULT_PRIVATE_KEY_LOCATION = AuthRule.class.getResource("/org/sdase/commons/server/auth/testing/rsa-private.key").toString();
    private static final String DEFAULT_CERTIFICATE_LOCATION = AuthRule.class.getResource("/org/sdase/commons/server/auth/testing/rsa-x.509.pem").toString();
    private RuleChain delegate;

    public static AuthRuleBuilder builder() {
        return new Builder();
    }

    private AuthRule(boolean disableAuth, String keyId, String issuer, String subject, String certificateLocation, String privateKeyLocation) {
        super(disableAuth, keyId, issuer, subject, privateKeyLocation, certificateLocation);
        this.init();
    }

    public AuthBuilder auth() {
        if (this.disableAuth) {
            throw new IllegalStateException("Could not create token when auth is disabled.");
        }
        return new AuthBuilder(this.keyId, this.privateKey).withIssuer(this.issuer).withSubject(this.subject);
    }

    public Statement apply(Statement base, Description description) {
        return this.delegate.apply(base, description);
    }

    @Deprecated
    public <C extends Configuration> Consumer<C> applyConfig(BiConsumer<C, AuthConfig> authConfigSetter) {
        return c -> authConfigSetter.accept(c, this.authConfig);
    }

    private void init() {
        if (this.disableAuth) {
            this.initDisabledTestAuth();
        } else {
            this.initEnabledTestAuth();
        }
    }

    private void initDisabledTestAuth() {
        this.authConfig = new AuthConfig().setDisableAuth(true);
        this.initTestAuth("{\"disableAuth\": true}");
    }

    private void initEnabledTestAuth() {
        this.privateKey = this.loadPrivateKey(this.privateKeyLocation);
        this.authConfig = new AuthConfig().setKeys(Collections.singletonList(this.createKeyLocation()));
        try {
            String authKeysConfig = new ObjectMapper().writeValueAsString((Object)this.authConfig);
            this.initTestAuth(authKeysConfig);
        }
        catch (JsonProcessingException e) {
            Assert.fail((String)("Failed to create the config keys: " + e.getMessage()));
        }
    }

    private void initTestAuth(String authConfig) {
        TestRule testRule = AuthRule.createTestRule(authConfig);
        this.delegate = RuleChain.outerRule((TestRule)testRule);
    }

    static TestRule createTestRule(String authConfig) {
        return SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16) ? new SystemPropertyRule().setProperty(AUTH_RULE_ENV_KEY, authConfig) : new EnvironmentRule().setEnv(AUTH_RULE_ENV_KEY, authConfig);
    }

    static /* synthetic */ String access$100() {
        return DEFAULT_KEY_ID;
    }

    static /* synthetic */ String access$200() {
        return DEFAULT_CERTIFICATE_LOCATION;
    }

    static /* synthetic */ String access$300() {
        return DEFAULT_PRIVATE_KEY_LOCATION;
    }

    public static class Builder
    implements AuthRuleBuilder,
    DisabledBuilder {
        private boolean disableAuth;
        private String keyId = AuthRule.access$100();
        private String issuer = "AuthRule";
        private String subject = "test";
        private String publicKeyCertificateLocation = AuthRule.access$200();
        private String privateKeyLocation = AuthRule.access$300();

        private Builder() {
        }

        @Override
        public AuthRuleBuilder withKeyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        @Override
        public AuthRuleBuilder withIssuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        @Override
        public AuthRuleBuilder withSubject(String subject) {
            this.subject = subject;
            return this;
        }

        @Override
        public AuthRuleBuilder withCustomKeyPair(String publicKeyCertificateLocation, String privateKeyLocation) {
            this.publicKeyCertificateLocation = publicKeyCertificateLocation;
            this.privateKeyLocation = privateKeyLocation;
            return this;
        }

        @Override
        public DisabledBuilder withDisabledAuth() {
            this.disableAuth = true;
            return this;
        }

        @Override
        public AuthRule build() {
            return new AuthRule(this.disableAuth, this.keyId, this.issuer, this.subject, this.publicKeyCertificateLocation, this.privateKeyLocation);
        }
    }

    public static interface DisabledBuilder {
        public AuthRule build();
    }

    public static interface AuthRuleBuilder {
        public AuthRuleBuilder withKeyId(String var1);

        public AuthRuleBuilder withIssuer(String var1);

        public AuthRuleBuilder withSubject(String var1);

        public AuthRuleBuilder withCustomKeyPair(String var1, String var2);

        public DisabledBuilder withDisabledAuth();

        public AuthRule build();
    }
}

