/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.opa.testing;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.sdase.commons.client.jersey.wiremock.testing.WireMockExtension;
import org.sdase.commons.server.opa.testing.AbstractOpa;

public class OpaClassExtension
extends AbstractOpa
implements BeforeAllCallback,
AfterAllCallback {
    private final WireMockExtension wireMockExtension = new WireMockExtension((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
    private String opaClientTimeoutBackup = null;

    public String getUrl() {
        return this.wireMockExtension.baseUrl();
    }

    public void reset() {
        this.wireMockExtension.resetAll();
    }

    public void beforeAll(ExtensionContext context) {
        this.opaClientTimeoutBackup = System.getProperty("dw.opa.opaClient.timeout");
        System.setProperty("dw.opa.opaClient.timeout", "1000ms");
        this.wireMockExtension.start();
    }

    public void afterAll(ExtensionContext context) {
        if (this.opaClientTimeoutBackup == null) {
            System.clearProperty("dw.opa.opaClient.timeout");
        } else {
            System.setProperty("dw.opa.opaClient.timeout", this.opaClientTimeoutBackup);
        }
        this.wireMockExtension.stop();
    }

    @Override
    void verify(int count, AbstractOpa.StubBuilder builder) {
        RequestPatternBuilder requestPattern = this.buildRequestPattern(builder);
        this.wireMockExtension.verify(count, requestPattern);
    }

    public void mock(AbstractOpa.BuildBuilder builder) {
        builder.build((WireMockServer)this.wireMockExtension);
    }
}

