/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.auth.testing;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class AuthBuilder {
    private final RSAPrivateKey privateKey;
    private String keyId;
    private String issuer;
    private String subject;
    private final Map<String, Object> claims = new HashMap<String, Object>();

    AuthBuilder(String keyId, RSAPrivateKey privateKey) {
        this.keyId = keyId;
        this.privateKey = privateKey;
    }

    public AuthBuilder withIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public AuthBuilder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public AuthBuilder addClaim(String key, Boolean value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, Integer value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, Long value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, String value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, Integer[] value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, Long[] value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, String[] value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, Double value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, Date value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaims(Map<String, Object> claims) {
        if (!claims.values().stream().allMatch(this::isSupportedClaimType)) {
            throw new IllegalArgumentException("Claims contain invalid type: " + claims);
        }
        this.claims.putAll(claims);
        return this;
    }

    private boolean isSupportedClaimType(Object o) {
        return o instanceof String || o instanceof String[] || o instanceof Integer || o instanceof Integer[] || o instanceof Long || o instanceof Long[] || o instanceof Double || o instanceof Boolean || o instanceof Date;
    }

    public String buildToken() {
        Algorithm algorithm = Algorithm.RSA256(null, (RSAPrivateKey)this.privateKey);
        JWTCreator.Builder builder = JWT.create().withKeyId(this.keyId).withIssuer(this.issuer).withSubject(this.subject);
        this.claims.keySet().forEach(key -> {
            Object value = this.claims.get(key);
            if (value instanceof String) {
                builder.withClaim(key, (String)value);
            } else if (value instanceof Long) {
                builder.withClaim(key, (Long)value);
            } else if (value instanceof Integer) {
                builder.withClaim(key, (Integer)value);
            } else if (value instanceof Double) {
                builder.withClaim(key, (Double)value);
            } else if (value instanceof Date) {
                builder.withClaim(key, (Date)value);
            } else if (value instanceof Boolean) {
                builder.withClaim(key, (Boolean)value);
            } else if (value instanceof String[]) {
                builder.withArrayClaim(key, (String[])value);
            } else if (value instanceof Long[]) {
                builder.withArrayClaim(key, (Long[])value);
            } else if (value instanceof Integer[]) {
                builder.withArrayClaim(key, (Integer[])value);
            }
        });
        return builder.sign(algorithm);
    }

    public String buildHeaderValue() {
        return "Bearer " + this.buildToken();
    }

    public MultivaluedMap<String, Object> buildAuthHeader() {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Authorization", (Object)this.buildHeaderValue());
        return headers;
    }
}

