/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.opa.testing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.util.Collection;
import java.util.Objects;
import javax.ws.rs.core.MultivaluedMap;
import org.sdase.commons.server.opa.filter.model.OpaResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpa {
    static final String OPA_CLIENT_TIMEOUT = "dw.opa.opaClient.timeout";
    static final String OPA_CLIENT_TIMEOUT_DEFAULT = "1000ms";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOpa.class);
    private static final ObjectMapper OM = new ObjectMapper();

    public static RequestMethodBuilder onRequest() {
        return new StubBuilder();
    }

    public static AllowBuilder onAnyRequest() {
        return new StubBuilder().onAnyRequest();
    }

    public void verify(int count, String httpMethod, String path) {
        this.verify(count, AbstractOpa.onRequest().withHttpMethod(httpMethod).withPath(path));
    }

    public void verify(int count, AllowBuilder allowBuilder) {
        this.verify(count, (StubBuilder)allowBuilder);
    }

    abstract void verify(int var1, StubBuilder var2);

    public RequestPatternBuilder buildRequestPattern(StubBuilder builder) {
        RequestPatternBuilder requestPattern;
        if (builder.onAnyRequest) {
            requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.POST, (UrlPattern)WireMock.urlMatching((String)"/.*"));
        } else {
            requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.POST, (UrlPattern)WireMock.urlMatching((String)"/.*")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.input.httpMethod", (StringValuePattern)WireMock.equalTo((String)builder.httpMethod))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.input.path", (StringValuePattern)WireMock.equalToJson((String)AbstractOpa.getJson(builder.paths))));
            if (builder.matchJWT) {
                requestPattern.withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.input.jwt", (StringValuePattern)(builder.jwt != null ? WireMock.equalTo((String)builder.jwt) : WireMock.absent())));
            }
        }
        return requestPattern;
    }

    static String getJson(String[] paths) {
        try {
            return OM.writeValueAsString((Object)paths);
        }
        catch (JsonProcessingException exception) {
            throw new IllegalStateException("Mock initialization failed");
        }
    }

    public static class StubBuilder
    implements RequestMethodBuilder,
    RequestPathBuilder,
    RequestExtraBuilder,
    AllowBuilder,
    FinalBuilder,
    BuildBuilder {
        private String httpMethod;
        private String[] paths;
        private boolean matchJWT;
        private String jwt;
        private boolean allow;
        private boolean onAnyRequest = false;
        private boolean errorResponse = false;
        private boolean emptyResponse = false;
        private OpaResponse answer;
        private Object constraint;

        @Override
        public void build(WireMockServer wire) {
            OpaResponse response;
            MappingBuilder mappingBuilder;
            if (this.isOnAnyRequest()) {
                mappingBuilder = this.matchAnyUrl();
            } else {
                mappingBuilder = this.matchInput(this.getHttpMethod(), this.getPaths());
                if (this.isMatchJWT()) {
                    mappingBuilder.withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.input.jwt", (StringValuePattern)(this.getJwt() != null ? WireMock.equalTo((String)this.getJwt()) : WireMock.absent())));
                }
            }
            if (this.isErrorResponse()) {
                wire.stubFor(mappingBuilder.willReturn(WireMock.aResponse().withStatus(500)));
                return;
            }
            if (this.isEmptyResponse()) {
                wire.stubFor(mappingBuilder.willReturn(null));
                return;
            }
            if (this.getAnswer() != null) {
                response = this.getAnswer();
            } else {
                ObjectNode objectNode = OM.createObjectNode();
                if (this.getConstraint() != null) {
                    objectNode = (ObjectNode)OM.valueToTree(this.getConstraint());
                }
                objectNode.put("allow", this.isAllow());
                response = new OpaResponse().setResult((JsonNode)objectNode);
            }
            wire.stubFor(mappingBuilder.willReturn(StubBuilder.getResponse(response)));
        }

        public boolean isAllow() {
            return this.allow;
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }

        public String[] getPaths() {
            return this.paths;
        }

        public boolean isMatchJWT() {
            return this.matchJWT;
        }

        public String getJwt() {
            return this.jwt;
        }

        public boolean isOnAnyRequest() {
            return this.onAnyRequest;
        }

        public boolean isErrorResponse() {
            return this.errorResponse;
        }

        public boolean isEmptyResponse() {
            return this.emptyResponse;
        }

        public OpaResponse getAnswer() {
            return this.answer;
        }

        public Object getConstraint() {
            return this.constraint;
        }

        static ResponseDefinitionBuilder getResponse(OpaResponse response) {
            try {
                return WireMock.aResponse().withStatus(200).withHeader("Content-type", new String[]{"application/json"}).withBody(OM.writeValueAsBytes((Object)response));
            }
            catch (JsonProcessingException exception) {
                throw new IllegalStateException("Mock initialization failed");
            }
        }

        StubBuilder onAnyRequest() {
            this.onAnyRequest = true;
            return this;
        }

        @Override
        public RequestPathBuilder withHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Override
        public RequestExtraBuilder withPath(String path) {
            this.paths = StubBuilder.splitPath(path);
            return this;
        }

        @Override
        public RequestExtraBuilder withJwt(String jwt) {
            this.matchJWT = true;
            this.jwt = jwt;
            return this;
        }

        @Override
        public StubBuilder allow() {
            this.allow = true;
            return this;
        }

        @Override
        public StubBuilder deny() {
            this.allow = false;
            return this;
        }

        @Override
        public BuildBuilder answer(OpaResponse answer) {
            this.answer = answer;
            return this;
        }

        @Override
        public BuildBuilder emptyResponse() {
            this.emptyResponse = true;
            return this;
        }

        @Override
        public BuildBuilder serverError() {
            this.errorResponse = true;
            return this;
        }

        @Override
        public FinalBuilder withConstraint(Object c) {
            this.constraint = c;
            return this;
        }

        MappingBuilder matchAnyPostUrl() {
            return WireMock.post((UrlPattern)WireMock.urlMatching((String)"/.*"));
        }

        MappingBuilder matchAnyUrl() {
            return WireMock.any((UrlPattern)WireMock.urlMatching((String)"/.*"));
        }

        MappingBuilder matchInput(String httpMethod, String[] paths) {
            return this.matchAnyPostUrl().withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.input.httpMethod", (StringValuePattern)WireMock.equalTo((String)httpMethod))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.input.path", (StringValuePattern)WireMock.equalToJson((String)AbstractOpa.getJson(paths))));
        }

        static String[] splitPath(String path) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            return path.split("/");
        }
    }

    public static interface BuildBuilder {
        public void build(WireMockServer var1);
    }

    public static interface FinalBuilder
    extends BuildBuilder {
        public FinalBuilder withConstraint(Object var1);
    }

    public static interface AllowBuilder {
        public FinalBuilder allow();

        public FinalBuilder deny();

        public BuildBuilder answer(OpaResponse var1);

        public BuildBuilder emptyResponse();

        public BuildBuilder serverError();
    }

    public static interface RequestExtraBuilder
    extends AllowBuilder {
        public RequestExtraBuilder withJwt(String var1);

        default public RequestExtraBuilder withJwtFromHeaderValue(String jwtWithBearerPrefix) {
            if (jwtWithBearerPrefix == null || !jwtWithBearerPrefix.toLowerCase().startsWith("bearer ")) {
                LOG.warn("Requested to mock OPA request from header value but no Bearer prefix found in {}", (Object)jwtWithBearerPrefix);
                return this;
            }
            return this.withJwt(jwtWithBearerPrefix.substring("bearer".length()).trim());
        }

        default public RequestExtraBuilder withJwtFromHeaders(MultivaluedMap<String, Object> headers) {
            String jwt = headers.keySet().stream().filter(Objects::nonNull).filter("Authorization"::equalsIgnoreCase).map(arg_0 -> headers.get(arg_0)).flatMap(Collection::stream).filter(Objects::nonNull).map(Object::toString).filter(authValue -> authValue.toLowerCase().startsWith("bearer ")).map(authValueWithBearer -> authValueWithBearer.substring("bearer".length()).trim()).findFirst().orElse(null);
            if (jwt != null) {
                return this.withJwt(jwt);
            }
            LOG.warn("Requested to mock OPA with JWT from headers but no JWT was found in {}", headers);
            return this;
        }
    }

    public static interface RequestPathBuilder {
        public RequestExtraBuilder withPath(String var1);
    }

    public static interface RequestMethodBuilder {
        public RequestPathBuilder withHttpMethod(String var1);
    }
}

