/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.auth.testing;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AuthBuilder {
    private final RSAPrivateKey privateKey;
    private final String keyId;
    private String issuer;
    private String subject;
    private final Map<String, Object> claims = new HashMap<String, Object>();

    AuthBuilder(String keyId, RSAPrivateKey privateKey) {
        this.keyId = keyId;
        this.privateKey = privateKey;
    }

    public AuthBuilder withIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public AuthBuilder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public AuthBuilder addClaim(String key, Boolean value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, Integer value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, Long value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, String value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, Integer[] value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, Long[] value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, String[] value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, Double value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaim(String key, Date value) {
        this.claims.put(key, value);
        return this;
    }

    public AuthBuilder addClaims(Map<String, Object> claims) {
        if (!claims.values().stream().allMatch(this::isSupportedClaimType)) {
            throw new IllegalArgumentException("Claims contain invalid type: " + String.valueOf(claims));
        }
        this.claims.putAll(claims);
        return this;
    }

    private boolean isSupportedClaimType(Object o) {
        return o instanceof String || o instanceof String[] || o instanceof Integer || o instanceof Integer[] || o instanceof Long || o instanceof Long[] || o instanceof Double || o instanceof Boolean || o instanceof Date;
    }

    public String buildToken() {
        Algorithm algorithm = Algorithm.RSA256(null, (RSAPrivateKey)this.privateKey);
        JWTCreator.Builder builder = JWT.create().withKeyId(this.keyId).withIssuer(this.issuer).withSubject(this.subject);
        this.claims.keySet().forEach(key -> {
            Object value = this.claims.get(key);
            if (value instanceof String) {
                String valueAsString = (String)value;
                builder.withClaim(key, valueAsString);
            } else if (value instanceof Long) {
                Long valueAsLong = (Long)value;
                builder.withClaim(key, valueAsLong);
            } else if (value instanceof Integer) {
                Integer valueAsInteger = (Integer)value;
                builder.withClaim(key, valueAsInteger);
            } else if (value instanceof Double) {
                Double valueAsDouble = (Double)value;
                builder.withClaim(key, valueAsDouble);
            } else if (value instanceof Date) {
                Date valueAsDate = (Date)value;
                builder.withClaim(key, valueAsDate);
            } else if (value instanceof Boolean) {
                Boolean valueAsBoolean = (Boolean)value;
                builder.withClaim(key, valueAsBoolean);
            } else if (value instanceof String[]) {
                String[] valueAsStringArray = (String[])value;
                builder.withArrayClaim(key, valueAsStringArray);
            } else if (value instanceof Long[]) {
                Long[] valueAsLongArray = (Long[])value;
                builder.withArrayClaim(key, valueAsLongArray);
            } else if (value instanceof Integer[]) {
                Integer[] valueAsIntegerArray = (Integer[])value;
                builder.withArrayClaim(key, valueAsIntegerArray);
            }
        });
        return builder.sign(algorithm);
    }

    public String buildHeaderValue() {
        return "Bearer " + this.buildToken();
    }

    public MultivaluedMap<String, Object> buildAuthHeader() {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Authorization", (Object)this.buildHeaderValue());
        return headers;
    }
}

