/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.auth;

import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.auth.AuthDynamicFeature;
import io.dropwizard.client.JerseyClientBuilder;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ScheduledExecutorService;
import javax.ws.rs.client.Client;
import javax.ws.rs.container.ContainerRequestFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.sdase.commons.server.auth.config.AuthConfig;
import org.sdase.commons.server.auth.config.AuthConfigProvider;
import org.sdase.commons.server.auth.config.KeyLocation;
import org.sdase.commons.server.auth.error.ForbiddenExceptionMapper;
import org.sdase.commons.server.auth.error.JwtAuthExceptionMapper;
import org.sdase.commons.server.auth.filter.JwtAuthFilter;
import org.sdase.commons.server.auth.key.JwksKeySource;
import org.sdase.commons.server.auth.key.KeySource;
import org.sdase.commons.server.auth.key.OpenIdProviderDiscoveryKeySource;
import org.sdase.commons.server.auth.key.PemKeySource;
import org.sdase.commons.server.auth.key.RsaKeyLoaderScheduler;
import org.sdase.commons.server.auth.key.RsaPublicKeyLoader;
import org.sdase.commons.server.auth.service.AuthRSA256Service;
import org.sdase.commons.server.auth.service.JwtAuthenticator;
import org.sdase.commons.server.opentracing.client.ClientTracingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AuthBundle.class);
    private AuthConfigProvider<T> configProvider;
    private boolean useAnnotatedAuthorization;
    private final Tracer tracer;

    public static ProviderBuilder builder() {
        return new Builder();
    }

    private AuthBundle(AuthConfigProvider<T> configProvider, boolean useAnnotatedAuthorization, Tracer tracer) {
        this.configProvider = configProvider;
        this.useAnnotatedAuthorization = useAnnotatedAuthorization;
        this.tracer = tracer;
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) {
        AuthConfig config = (AuthConfig)this.configProvider.apply(configuration);
        if (config.isDisableAuth()) {
            LOG.warn("Authentication is disabled. This setting should NEVER be used in production.");
        }
        Tracer currentTracer = this.tracer == null ? GlobalTracer.get() : this.tracer;
        Client client = this.createKeyLoaderClient(environment, config, currentTracer);
        RsaPublicKeyLoader keyLoader = new RsaPublicKeyLoader();
        config.getKeys().stream().map(k -> this.createKeySources((KeyLocation)k, client)).forEach(keyLoader::addKeySource);
        ScheduledExecutorService executorService = environment.lifecycle().scheduledExecutorService("reloadKeysExecutorService").build();
        RsaKeyLoaderScheduler.create(keyLoader, executorService).start();
        AuthRSA256Service authRSA256Service = new AuthRSA256Service(keyLoader, config.getLeeway());
        JwtAuthenticator authenticator = new JwtAuthenticator(authRSA256Service, config.isDisableAuth());
        JwtAuthFilter authFilter = (JwtAuthFilter)new JwtAuthFilter.Builder().withTracer(currentTracer).setAcceptAnonymous(!this.useAnnotatedAuthorization).setAuthenticator(authenticator).buildAuthFilter();
        if (this.useAnnotatedAuthorization) {
            environment.jersey().register((Object)new AuthDynamicFeature((ContainerRequestFilter)authFilter));
        } else {
            environment.jersey().register((Object)authFilter);
        }
        environment.jersey().register(JwtAuthExceptionMapper.class);
        environment.jersey().register(ForbiddenExceptionMapper.class);
    }

    private Client createKeyLoaderClient(Environment environment, AuthConfig config, Tracer tracer) {
        JerseyClientBuilder jerseyClientBuilder = new JerseyClientBuilder(environment);
        if (config.getKeyLoaderClient() == null || config.getKeyLoaderClient().getProxyConfiguration() == null) {
            jerseyClientBuilder.using((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
        }
        if (config.getKeyLoaderClient() != null) {
            jerseyClientBuilder.using(config.getKeyLoaderClient());
        }
        Client client = jerseyClientBuilder.build("keyLoader");
        ClientTracingUtil.registerTracing((Client)client, (Tracer)tracer);
        return client;
    }

    private KeySource createKeySources(KeyLocation keyLocation, Client client) {
        switch (keyLocation.getType()) {
            case PEM: {
                return new PemKeySource(keyLocation.getPemKeyId(), keyLocation.getLocation(), keyLocation.getRequiredIssuer());
            }
            case OPEN_ID_DISCOVERY: {
                this.validateKeyLocation(keyLocation.getLocation(), keyLocation.getRequiredIssuer());
                return new OpenIdProviderDiscoveryKeySource(keyLocation.getLocation().toASCIIString(), client, keyLocation.getRequiredIssuer());
            }
            case JWKS: {
                this.validateKeyLocation(keyLocation.getLocation(), keyLocation.getRequiredIssuer());
                return new JwksKeySource(keyLocation.getLocation().toASCIIString(), client, keyLocation.getRequiredIssuer());
            }
        }
        throw new IllegalArgumentException("KeyLocation has no valid type: " + (Object)((Object)keyLocation.getType()));
    }

    private void validateKeyLocation(URI location, String requiredIssuer) {
        if (StringUtils.isNotBlank((CharSequence)requiredIssuer) && StringUtils.contains((CharSequence)requiredIssuer, (int)58)) {
            try {
                URI issuerUri = new URI(requiredIssuer);
                if (!StringUtils.equalsIgnoreCase((CharSequence)location.getHost(), (CharSequence)issuerUri.getHost())) {
                    LOG.warn("The required issuer host name <{}> for the key <{}> does not match to the key source uri host name <{}>.", new Object[]{issuerUri.getHost(), location, location.getHost()});
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("The requiredIssuer <" + requiredIssuer + "> is no valid stringOrURI", e);
            }
        }
    }

    public static class Builder<C extends Configuration>
    implements ProviderBuilder,
    AuthorizationBuilder<C>,
    AuthBuilder<C> {
        private AuthConfigProvider<C> authConfigProvider;
        private boolean useAnnotatedAuthorization = true;
        private Tracer tracer;

        private Builder() {
        }

        private Builder(AuthConfigProvider<C> authConfigProvider) {
            this.authConfigProvider = authConfigProvider;
        }

        public <T extends Configuration> AuthorizationBuilder<T> withAuthConfigProvider(AuthConfigProvider<T> authConfigProvider) {
            return new Builder<T>(authConfigProvider);
        }

        @Override
        public AuthBuilder<C> withAnnotatedAuthorization() {
            this.useAnnotatedAuthorization = true;
            return this;
        }

        @Override
        public AuthBuilder<C> withExternalAuthorization() {
            this.useAnnotatedAuthorization = false;
            return this;
        }

        @Override
        public AuthBuilder<C> withTracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        @Override
        public AuthBundle<C> build() {
            return new AuthBundle(this.authConfigProvider, this.useAnnotatedAuthorization, this.tracer);
        }
    }

    public static interface AuthBuilder<C extends Configuration> {
        public AuthBuilder<C> withTracer(Tracer var1);

        public AuthBundle<C> build();
    }

    public static interface AuthorizationBuilder<C extends Configuration> {
        public AuthBuilder<C> withAnnotatedAuthorization();

        public AuthBuilder<C> withExternalAuthorization();
    }

    public static interface ProviderBuilder {
        public <C extends Configuration> AuthorizationBuilder<C> withAuthConfigProvider(AuthConfigProvider<C> var1);
    }
}

