/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.auth;

import com.auth0.jwt.interfaces.Claim;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;

public class JwtPrincipal
implements Principal {
    private static final String DEFAULT_NAME = JwtPrincipal.class.getSimpleName();
    private String name;
    private String jwt;
    private Map<String, Claim> claims;

    private JwtPrincipal(String name, String jwt, Map<String, Claim> claims) {
        this.name = name;
        this.jwt = jwt;
        this.claims = claims;
    }

    public static JwtPrincipal emptyPrincipal() {
        return new JwtPrincipal(null, null, new HashMap<String, Claim>());
    }

    public static JwtPrincipal verifiedPrincipal(String jwt, Map<String, Claim> claims) {
        return new JwtPrincipal(DEFAULT_NAME, jwt, claims);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getJwt() {
        return this.jwt;
    }

    public Map<String, Claim> getClaims() {
        return this.claims;
    }
}

