/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.auth.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.dropwizard.client.JerseyClientConfiguration;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.sdase.commons.server.auth.config.KeyLocation;
import org.sdase.commons.server.auth.config.KeyUriType;

public class AuthConfig {
    private JerseyClientConfiguration keyLoaderClient;
    private final List<KeyLocation> keys = new ArrayList<KeyLocation>();
    @JsonIgnore
    private final List<KeyLocation> keysFromIssuers = new ArrayList<KeyLocation>();
    private long leeway = 0L;
    private boolean disableAuth;

    public JerseyClientConfiguration getKeyLoaderClient() {
        return this.keyLoaderClient;
    }

    public AuthConfig setKeyLoaderClient(JerseyClientConfiguration keyLoaderClient) {
        this.keyLoaderClient = keyLoaderClient;
        return this;
    }

    public List<KeyLocation> getKeys() {
        ArrayList<KeyLocation> combinedKeys = new ArrayList<KeyLocation>();
        combinedKeys.addAll(this.keys);
        combinedKeys.addAll(this.keysFromIssuers);
        return combinedKeys;
    }

    public AuthConfig setKeys(List<KeyLocation> keys) {
        this.keys.clear();
        if (keys != null) {
            this.keys.addAll(keys);
        }
        return this;
    }

    public long getLeeway() {
        return this.leeway;
    }

    public AuthConfig setLeeway(long leeway) {
        this.leeway = leeway;
        return this;
    }

    public boolean isDisableAuth() {
        return this.disableAuth;
    }

    public AuthConfig setDisableAuth(boolean disableAuth) {
        this.disableAuth = disableAuth;
        return this;
    }

    public AuthConfig setIssuers(String commaSeparatedIssuers) {
        this.keysFromIssuers.clear();
        if (commaSeparatedIssuers != null) {
            Stream.of(commaSeparatedIssuers.split(",")).filter(StringUtils::isNotBlank).map(String::trim).map(iss -> new KeyLocation().setType(KeyUriType.OPEN_ID_DISCOVERY).setLocation(URI.create(iss)).setRequiredIssuer((String)iss)).forEach(this.keysFromIssuers::add);
        }
        return this;
    }
}

