/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.auth.filter;

import io.dropwizard.auth.AuthFilter;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedMap;
import org.sdase.commons.server.auth.error.JwtAuthException;

@Priority(value=1000)
public class JwtAuthFilter<P extends Principal>
extends AuthFilter<Optional<String>, P> {
    private static final String AUTHENTICATION_SCHEME_BEARER = "Bearer";
    private static final String AUTHENTICATED = "authenticated";
    private boolean acceptAnonymous;
    private Tracer tracer;

    private JwtAuthFilter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext) {
        Span span = this.tracer.buildSpan("validateToken").withTag((Tag)Tags.COMPONENT, (Object)"JwtAuthFilter").withTag(AUTHENTICATED, false).start();
        try (Scope ignored = this.tracer.scopeManager().activate(span);){
            MultivaluedMap headers = requestContext.getHeaders();
            String jwt = this.extractAuthorizationToken((MultivaluedMap<String, String>)headers);
            boolean authenticated = this.authenticate(requestContext, Optional.ofNullable(jwt), "BASIC");
            span.setTag(AUTHENTICATED, authenticated);
            if (!this.acceptAnonymous && !authenticated) {
                throw new JwtAuthException("Credentials are required to access this resource.");
            }
        }
        finally {
            span.finish();
        }
    }

    private String extractAuthorizationToken(MultivaluedMap<String, String> headers) {
        List authorization = (List)headers.get((Object)"Authorization");
        if (authorization == null || authorization.isEmpty()) {
            return null;
        }
        String authorizationHeader = (String)authorization.get(0);
        if (!authorizationHeader.contains(AUTHENTICATION_SCHEME_BEARER)) {
            return null;
        }
        return authorizationHeader.replaceFirst("Bearer ", "");
    }

    public static class Builder<P extends Principal>
    extends AuthFilter.AuthFilterBuilder<Optional<String>, P, JwtAuthFilter<P>> {
        private boolean acceptAnonymous;
        private Tracer tracer = NoopTracerFactory.create();

        protected JwtAuthFilter<P> newInstance() {
            return new JwtAuthFilter();
        }

        public Builder<P> setAcceptAnonymous(boolean acceptAnonymous) {
            this.acceptAnonymous = acceptAnonymous;
            return this;
        }

        public Builder<P> withTracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public JwtAuthFilter<P> buildAuthFilter() {
            JwtAuthFilter jwtAuthFilter = (JwtAuthFilter)super.buildAuthFilter();
            jwtAuthFilter.acceptAnonymous = this.acceptAnonymous;
            jwtAuthFilter.tracer = this.tracer;
            return jwtAuthFilter;
        }
    }
}

