/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.auth.key;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import org.sdase.commons.server.auth.key.JwksKeySource;
import org.sdase.commons.server.auth.key.KeyLoadFailedException;
import org.sdase.commons.server.auth.key.KeySource;
import org.sdase.commons.server.auth.key.LoadedPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdProviderDiscoveryKeySource
implements KeySource {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIdProviderDiscoveryKeySource.class);
    public static final String DISCOVERY_PATH = "/.well-known/openid-configuration";
    private final String issuerUrl;
    private final Client client;
    private final String requiredIssuer;

    public OpenIdProviderDiscoveryKeySource(String issuerUrl, Client client, String requiredIssuer) {
        this.issuerUrl = issuerUrl;
        this.client = client;
        this.requiredIssuer = requiredIssuer;
    }

    @Override
    public List<LoadedPublicKey> loadKeysFromSource() {
        try {
            Discovery discovery = (Discovery)this.client.target(this.issuerUrl.replaceAll("/$", "") + DISCOVERY_PATH).request(new String[]{"application/json"}).get(Discovery.class);
            List<LoadedPublicKey> loadedPublicKeys = new JwksKeySource(discovery.getJwksUri(), this.client, this.requiredIssuer).loadKeysFromSource();
            return loadedPublicKeys.stream().map(k -> new LoadedPublicKey(k.getKid(), k.getPublicKey(), this, this.requiredIssuer)).collect(Collectors.toList());
        }
        catch (KeyLoadFailedException e) {
            throw e;
        }
        catch (WebApplicationException e) {
            try {
                e.getResponse().close();
            }
            catch (ProcessingException ex) {
                LOGGER.warn("Error while loading keys from OpenId Provider Discovery while closing response", (Throwable)ex);
            }
            throw new KeyLoadFailedException(e);
        }
        catch (Exception e) {
            throw new KeyLoadFailedException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenIdProviderDiscoveryKeySource that = (OpenIdProviderDiscoveryKeySource)o;
        return Objects.equals(this.issuerUrl, that.issuerUrl) && Objects.equals(this.client, that.client);
    }

    public int hashCode() {
        return Objects.hash(this.issuerUrl, this.client);
    }

    public String toString() {
        return "OpenIdProviderDiscoveryKeySource{issuerUrl='" + this.issuerUrl + '\'' + '}';
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Discovery {
        @JsonProperty(value="jwks_uri")
        private String jwksUri;

        private Discovery() {
        }

        public String getJwksUri() {
            return this.jwksUri;
        }

        public Discovery setJwksUri(String jwksUri) {
            this.jwksUri = jwksUri;
            return this;
        }
    }
}

