/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.auth.key;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.sdase.commons.server.auth.key.RsaPublicKeyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaKeyLoaderScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RsaKeyLoaderScheduler.class);
    private static final int DEFAULT_INITIAL_DELAY = 5;
    private static final int DEFAULT_PERIOD = 5;
    private static final TimeUnit DEFAULT_TIMEUNIT = TimeUnit.MINUTES;
    private ScheduledExecutorService reloadKeysExecutorService;
    private RsaPublicKeyLoader keyLoader;

    private RsaKeyLoaderScheduler(RsaPublicKeyLoader keyLoader, ScheduledExecutorService reloadKeysExecutorService) {
        this.keyLoader = keyLoader;
        this.reloadKeysExecutorService = reloadKeysExecutorService;
    }

    public static RsaKeyLoaderScheduler create(RsaPublicKeyLoader keyLoader, ScheduledExecutorService reloadKeysExecutorService) {
        Validate.notNull((Object)keyLoader, (String)"keyLoader should not be null", (Object[])new Object[0]);
        Validate.notNull((Object)reloadKeysExecutorService, (String)"executorService should not be null", (Object[])new Object[0]);
        return new RsaKeyLoaderScheduler(keyLoader, reloadKeysExecutorService);
    }

    public RsaKeyLoaderScheduler start() {
        return this.internalStart(5, 5, DEFAULT_TIMEUNIT);
    }

    RsaKeyLoaderScheduler internalStart(int initialDelay, int period, TimeUnit timeUnit) {
        Runnable reloadKeysTask = () -> {
            try {
                this.keyLoader.reloadKeys();
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while reloading public keys", (Throwable)e);
            }
        };
        this.reloadKeysExecutorService.scheduleAtFixedRate(reloadKeysTask, initialDelay, period, timeUnit);
        return this;
    }
}

