/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.auth.key;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.sdase.commons.server.auth.key.KeyLoadFailedException;
import org.sdase.commons.server.auth.key.KeySource;
import org.sdase.commons.server.auth.key.LoadedPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaPublicKeyLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(RsaPublicKeyLoader.class);
    private Map<String, LoadedPublicKey> keysByKid = new ConcurrentHashMap<String, LoadedPublicKey>();
    private Set<LoadedPublicKey> keysWithoutKeyId = new CopyOnWriteArraySet<LoadedPublicKey>();
    private Map<KeySource, Boolean> keySources = new ConcurrentHashMap<KeySource, Boolean>();
    private final Object loadingSemaphore = new Object();

    public List<LoadedPublicKey> getKeysWithoutId() {
        if (this.keysWithoutKeyId.isEmpty()) {
            this.reloadKeys();
        }
        return new ArrayList<LoadedPublicKey>(this.keysWithoutKeyId);
    }

    public LoadedPublicKey getLoadedPublicKey(String kid) {
        if (kid == null) {
            return null;
        }
        LoadedPublicKey key = this.keysByKid.get(kid);
        if (key != null) {
            return key;
        }
        this.reloadKeys();
        return this.keysByKid.get(kid);
    }

    public void addKeySource(KeySource keySource) {
        this.keySources.put(keySource, false);
        new Thread(this::loadAllNewKeys).start();
    }

    public int getTotalNumberOfKeySources() {
        return this.keySources.size();
    }

    public int getTotalNumberOfKeys() {
        return this.keysWithoutKeyId.size() + this.keysByKid.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadKeys() {
        Object object = this.loadingSemaphore;
        synchronized (object) {
            this.keySources.keySet().forEach(ks -> {
                this.keySources.put((KeySource)ks, true);
                this.reloadFromKeySource((KeySource)ks);
            });
        }
    }

    private void reloadFromKeySource(KeySource keySource) {
        Optional<List<LoadedPublicKey>> loadedPublicKeys = keySource.reloadKeysFromSource();
        if (loadedPublicKeys.isPresent()) {
            List<LoadedPublicKey> keys = loadedPublicKeys.get();
            this.removeOldKeysFromSource(keySource, keys);
            keys.forEach(this::addKey);
        }
    }

    private void removeOldKeysFromSource(KeySource keySource, List<LoadedPublicKey> newKeys) {
        this.keysWithoutKeyId.removeIf(k -> keySource.equals(k.getKeySource()) && !newKeys.contains(k));
        Set newKeyIds = newKeys.stream().map(LoadedPublicKey::getKid).filter(Objects::nonNull).collect(Collectors.toSet());
        this.keysByKid.values().stream().filter(k -> keySource.equals(k.getKeySource())).map(LoadedPublicKey::getKid).filter(kid -> !newKeyIds.contains(kid)).forEach(this.keysByKid::remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllNewKeys() {
        try {
            Object object = this.loadingSemaphore;
            synchronized (object) {
                this.keySources.keySet().stream().filter(ks -> this.keySources.get(ks) == false).map(ks -> {
                    this.keySources.put((KeySource)ks, true);
                    return this.silentlyLoadKeysFromSource((KeySource)ks);
                }).flatMap(Collection::stream).forEach(this::addKey);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to initially load keys in a dedicated Thread", t);
        }
    }

    private List<LoadedPublicKey> silentlyLoadKeysFromSource(KeySource keySource) {
        try {
            return keySource.loadKeysFromSource();
        }
        catch (KeyLoadFailedException e) {
            LOGGER.error("An error occurred while loading new keys from {}", (Object)keySource, (Object)e);
            return Collections.emptyList();
        }
    }

    private void addKey(LoadedPublicKey key) {
        if (key.getKid() == null) {
            this.keysWithoutKeyId.add(key);
        } else {
            this.keysByKid.put(key.getKid(), key);
        }
    }
}

