/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.auth.service;

import com.auth0.jwt.interfaces.Claim;
import io.dropwizard.auth.Authenticator;
import java.util.Map;
import java.util.Optional;
import org.sdase.commons.server.auth.JwtPrincipal;
import org.sdase.commons.server.auth.service.AuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAuthenticator
implements Authenticator<Optional<String>, JwtPrincipal> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtAuthenticator.class);
    private AuthService authService;
    private boolean disabled;

    public JwtAuthenticator(AuthService authService, boolean disabled) {
        this.authService = authService;
        this.disabled = disabled;
    }

    public Optional<JwtPrincipal> authenticate(Optional<String> credentials) {
        if (this.disabled) {
            LOGGER.warn("Authentication is disabled. This setting shall never be active in production. To fix this warning remove configuration 'auth.disableAuth'.");
            return Optional.of(JwtPrincipal.emptyPrincipal());
        }
        if (!credentials.isPresent()) {
            LOGGER.info("No access token received");
            return Optional.empty();
        }
        Map<String, Claim> claims = this.authService.auth(credentials.get());
        return Optional.of(JwtPrincipal.verifiedPrincipal(credentials.get(), claims));
    }
}

